package com.digiwin.athena.dto.assembly.variable;

import lombok.Data;

import java.util.List;

/**
 * 设计器变量树节点DTO
 */
@Data
public class VarDefNode {

    /**
     * 节点标签
     */
    private String label;

    /**
     * 节点值
     */
    private String value;

    /**
     * 节点类型：'string' | 'number' | 'boolean' | 'object' | 'datetime'
     */
    private String type;

    /**
     * children引用变量计算表达式
     */
    private String reference;

    /**
     * 表达式字符串
     */
    private String valEvalExpr;

    /**
     * 全路径
     */
    private String fullPath;

    /**
     * 子节点列表
     */
    private List<VarDefNode> children;


}
