package com.digiwin.athena.dto.asset;

import com.digiwin.athena.domain.pagedesign.TenantInfo;
import com.digiwin.athena.mongodb.domain.application.AssetDefinition;
import io.swagger.v3.oas.annotations.media.Schema;

import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;

public class AssetBatchOpenReqDto {
    @Size(min = 1,message = "资产id不能为空")
    private List<String> assetIds = new ArrayList<>();
    @Schema(description = "应用code")
    @NotEmpty(message = "应用code不能为空")
    private String application;
    private List<String> tags = new ArrayList<>();
    private Boolean canReference = false;
    private Boolean canCopy = false;
    private String openRange = AssetDefinition.CUR_TENANT_RANGE;

    private List<TenantInfo> tenantInfos = new ArrayList<>();

    public String getApplication() {
        return application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public List<String> getAssetIds() {
        return assetIds;
    }

    public void setAssetIds(List<String> assetIds) {
        this.assetIds = assetIds;
    }

    public List<String> getTags() {
        return tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public Boolean getCanReference() {
        return canReference;
    }

    public void setCanReference(Boolean canReference) {
        this.canReference = canReference;
    }

    public Boolean getCanCopy() {
        return canCopy;
    }

    public void setCanCopy(Boolean canCopy) {
        this.canCopy = canCopy;
    }

    public String getOpenRange() {
        return openRange;
    }

    public void setOpenRange(String openRange) {
        this.openRange = openRange;
    }

    public List<TenantInfo> getTenantInfos() {
        return tenantInfos;
    }

    public void setTenantInfos(List<TenantInfo> tenantInfos) {
        this.tenantInfos = tenantInfos;
    }
}
