package com.digiwin.athena.dto.asset;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.config.BranchConfig;
import com.digiwin.athena.constant.Constant;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.dto.businessData.BusinessDataDto;
import com.digiwin.athena.enums.VersionStatusEnum;
import com.digiwin.athena.mongodb.domain.application.Asset;
import com.digiwin.athena.mongodb.domain.application.AssetDefinition;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

import java.util.List;
import java.util.Map;

@Data
public class AssetInfoDto {

    public static final String SD_SOURCE = "SD";
    public static final String CB_SOURCE = "CB";


    private String code;
    private Map metadata;
    private Map<String, List<Map<String, Object>>> content;
    private String application;
    private String adpVersion="0";
    private String adpTenantId;
    private String assetName;
    /**
     * 资产来源|SD-独立资产，CB-组合资产
     */
    private String source;
    private String sourceBranch=BranchConfig.DEV_BRANCH_NAME;
    /**
     * 状态|draft-草稿，effect-生效
     */
    private String adpStatus;
    private BusinessDataDto businessData;
    private Integer adpRemarkNumber;
    private Map<String, MultiLanguageDTO> lang;

    public Boolean judgeSaveRequiredFields() {
        return StringUtils.isNotEmpty(code)
                && StringUtils.isNotEmpty(application)
                && StringUtils.isNotEmpty(adpVersion)
                && StringUtils.isNotEmpty(adpTenantId)
                && StringUtils.isNotEmpty(source)
                && StringUtils.isNotEmpty(sourceBranch)
                && StringUtils.isNotEmpty(adpStatus);
    }

    public Boolean judgeDeleteRequiredFields() {
        return StringUtils.isNotEmpty(code)
                && StringUtils.isNotEmpty(application)
                && StringUtils.isNotEmpty(sourceBranch)
                && StringUtils.isNotEmpty(adpStatus);
    }

    public VersionStatusEnum assetAdpStatus() {
        //没有多版本
        if ("0".equals(this.adpVersion)&&BranchConfig.DEV_BRANCH_NAME.equals(this.sourceBranch)) {
            return VersionStatusEnum.RUN_STATE;
        }

        if (BranchConfig.DEV_BRANCH_NAME.equals(this.sourceBranch) && VersionStatusEnum.RUN_STATE.getCode().equals(this.getAdpStatus())) {
            return VersionStatusEnum.RUN_STATE;
        } else {
            return VersionStatusEnum.DESIGN_STATE;
        }
    }

    public AssetDefinition convertAssetDefinition(){
        AssetDefinition assetDefinition = new AssetDefinition();
        assetDefinition.setAssetName(StringUtils.isNotEmpty(this.assetName)?this.assetName:this.code);
        assetDefinition.setCode(this.code);
        assetDefinition.setSource(this.source);
        assetDefinition.setLang(this.lang);
        assetDefinition.setAdpTenantId(this.adpTenantId);
        assetDefinition.getManageContext().setApplication(this.application);
        return assetDefinition;
    }

    public Asset convertAsset() {
        Asset asset = new Asset();
        BeanUtils.copyProperties(this,asset,"businessData");
        if (businessData!=null){
            asset.setBusinessData(JSONObject.toJSONString(businessData));
        }
        //只有开发分支的生效版本，在资产版本中才能生效
        Asset.ManageContext manageContext = asset.getManageContext();
        manageContext.setDataId(this.code+ Constant.SINGLE_CODE_SEPARATOR+this.sourceBranch+ Constant.SINGLE_CODE_SEPARATOR+this.adpVersion);
        manageContext.setAdpStatus(assetAdpStatus().getCode());
        manageContext.setApplication(this.application);
        manageContext.setBranch(this.sourceBranch);
        manageContext.setAdpVersion(this.adpVersion);

        Asset.ShowField showFields = asset.getShowFields();
        showFields.setAdpRemarkNumber(this.adpRemarkNumber);

        return asset;
    }

    public static AssetInfoDto create(Asset asset){
        AssetInfoDto assetInfoDto = new AssetInfoDto();
        BeanUtils.copyProperties(asset,assetInfoDto);

        Asset.ManageContext manageContext = asset.getManageContext();
        assetInfoDto.setApplication(manageContext.getApplication());
        assetInfoDto.setSourceBranch(manageContext.getBranch());
        assetInfoDto.setAdpVersion(manageContext.getAdpVersion());
        assetInfoDto.setAdpStatus(manageContext.getAdpStatus());

        Asset.ShowField showFields = asset.getShowFields();
        assetInfoDto.setAdpRemarkNumber(showFields.getAdpRemarkNumber());

        return assetInfoDto;
    }

}
