package com.digiwin.athena.dto.asset;

import com.digiwin.athena.mongodb.domain.application.Asset;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.beans.BeanUtils;

@Data
public class AssetInfoResDto {
    @Schema(description = "id")
    private String objectId;
    @Schema(description = "资产id")
    private String assetId;
    @Schema(description = "业务code")
    private String code;
    @Schema(description = "归属应用")
    private String application;
    @Schema(description = "版本号")
    private String adpVersion;
    @Schema(description = "备注序列号")
    private Integer adpRemarkNumber;
    @Schema(description = "分支")
    private String sourceBranch;
    @Schema(description = "资产状态|draft-草稿，effect-生效")
    private String adpStatus;

    public static AssetInfoResDto create(Asset asset){
        AssetInfoResDto assetInfoResDto = new AssetInfoResDto();
        BeanUtils.copyProperties(asset,assetInfoResDto);
        Asset.ManageContext manageContext = asset.getManageContext();
        if (manageContext!=null){
            assetInfoResDto.setApplication(manageContext.getApplication());
            assetInfoResDto.setSourceBranch(manageContext.getBranch());
            assetInfoResDto.setAdpVersion(manageContext.getAdpVersion());
            assetInfoResDto.setAdpStatus(manageContext.getAdpStatus());
        }
        return assetInfoResDto;
    }
}
