package com.digiwin.athena.dto.asset;

import com.digiwin.athena.domain.pagedesign.TenantInfo;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.mongodb.domain.application.AssetDefinition;
import io.swagger.v3.oas.annotations.media.Schema;

import jakarta.validation.constraints.NotEmpty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AssetOpenReqDto {
    @Schema(description = "资产id")
    @NotEmpty(message = "资产id不能为空")
    private String assetId;
    @Schema(description = "应用code")
    @NotEmpty(message = "应用code不能为空")
    private String application;
    @Schema(description = "资产名称")
    @NotEmpty(message = "资产名称不能为空")
    private String assetName;
    @Schema(description = "资产描述")
    private String assetDesc;
    @Schema(description = "标签")
    private List<String> tags = new ArrayList<>();
    @Schema(description = "能否引用")
    private Boolean canReference = false;
    @Schema(description = "能否复制")
    private Boolean canCopy = false;
    @Schema(description = "可复制列表,记录的每个版本的objectId")
    private List<String> copyableItems = new ArrayList<>();
    @Schema(description = "开放范围|all-全部，tenant-租户，curTenant-当前租户")
    @NotEmpty(message = "开放范围必选")
    private String openRange = AssetDefinition.CUR_TENANT_RANGE;
    @Schema(description = "指定开发的租户id|openRange=tenant时")
    private List<TenantInfo> tenantInfos = new ArrayList<>();
    private Map<String, MultiLanguageDTO> lang;

    public Map<String, MultiLanguageDTO> getLang() {
        return lang;
    }

    public void setLang(Map<String, MultiLanguageDTO> lang) {
        this.lang = lang;
    }

    public String getApplication() {
        return application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public List<TenantInfo> getTenantInfos() {
        return tenantInfos;
    }

    public void setTenantInfos(List<TenantInfo> tenantInfos) {
        this.tenantInfos = tenantInfos;
    }

    public String getAssetId() {
        return assetId;
    }

    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public String getAssetName() {
        return assetName;
    }

    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }

    public String getAssetDesc() {
        return assetDesc;
    }

    public void setAssetDesc(String assetDesc) {
        this.assetDesc = assetDesc;
    }

    public List<String> getTags() {
        return tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public Boolean getCanReference() {
        return canReference;
    }

    public void setCanReference(Boolean canReference) {
        this.canReference = canReference;
    }

    public Boolean getCanCopy() {
        return canCopy;
    }

    public void setCanCopy(Boolean canCopy) {
        this.canCopy = canCopy;
    }

    public List<String> getCopyableItems() {
        return copyableItems;
    }

    public void setCopyableItems(List<String> copyableItems) {
        this.copyableItems = copyableItems;
    }

    public String getOpenRange() {
        return openRange;
    }

    public void setOpenRange(String openRange) {
        this.openRange = openRange;
    }
}
