package com.digiwin.athena.dto.asset;

import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

@EqualsAndHashCode(callSuper = true)
@Data
public class AssetPagination<T> extends Pagination<T> {
    /**
     * 是否具有可查询权限
     */
    private Boolean hasAuth = true;



    public static <T> AssetPagination<T> buildPagination(PageReqCondition pageReqCondition, List<T> records, Long count) {
        AssetPagination res = new AssetPagination<>();
        res.setData(records);
        res.setTotal(count);
        res.setCurPageNum(pageReqCondition.getPageNum());
        res.setTotalPageNum(count.intValue() / pageReqCondition.getPageSize() + 1);
        res.setLimit(pageReqCondition.getPageSize());

        return res;
    }
}
