package com.digiwin.athena.dto.asset;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

@Data
public class UseAssetListReqDto {

    public static final Integer CUR_TENANT_RANGE = 1;
    public static final Integer OTHER_TENANT_RANGE = 2;

    public static final String ALL_TYPE = "ALL";
    public static final String DTD_TYPE = "DTD";

    @Schema(description = "type=ALL|DTD,ALL查询所有")
    private String type = ALL_TYPE;
    @Schema(description = "1,2|1-查询当前租户的，2-查询其他租户")
    private Integer range = CUR_TENANT_RANGE;

    @Schema(description = "搜索内容")
    private String searchContent;
    @Schema(description = "筛选可引用")
    private Boolean canReference;
    @Schema(description = "筛选可复制")
    private Boolean canCopy;
}
