package com.digiwin.athena.dto.assetType;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import lombok.Data;

import java.util.Comparator;
import java.util.List;
import java.util.Map;

@Data
public class AssetTypeBaseDTO {
    private String objId;

    /**
     * @see AssetTypeResDto#getType()
     */
    private String type;

    /**
     * @see AssetTypeResDto#getName()
     */
    private String name;

    private Map<String, MultiLanguageDTO<String>> lang;

    public static AssetTypeBaseDTO from(AssetTypeResDto v) {
        if (v == null) {
            return null;
        }
        AssetTypeBaseDTO dto = new AssetTypeBaseDTO();

        dto.setObjId(v.getObjId());
        dto.setType(v.getType());
        dto.setName(v.getName());
        dto.setLang(v.getLang());

        return dto;
    }

    public static List<AssetTypeBaseDTO> sort(List<AssetTypeBaseDTO> list, Map<String, AssetTypeResDto> assetTypeIdMap) {
        return CollUtil.emptyIfNull(list).stream()
                .map(v -> assetTypeIdMap.computeIfAbsent(v.getObjId(), k -> v.toAssetTypeResDto()))
                .sorted(Comparator.comparingLong(AssetTypeResDto::obtainShowSort))
                .map(AssetTypeBaseDTO::from)
                .toList();
    }

    public AssetTypeResDto toAssetTypeResDto() {
        AssetTypeResDto dto = new AssetTypeResDto();

        dto.setObjId(getObjId());
        dto.setType(getType());
        dto.setName(getName());
        dto.setLang(getLang());

        return dto;
    }


}
