package com.digiwin.athena.dto.assetType;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.constants.enums.assembly.OnlineState;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.mongodb.domain.ApiInfo;
import com.digiwin.athena.mongodb.domain.assetType.AssetType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.util.*;

@Data
public class AssetTypeResDto {

    private String objId;

    @Schema(description = "资产类型")
    private String type;
    @Schema(description = "资产名称")
    private String name;
    @Schema(description = "资产版本")
    private String version;
    @Schema(description = "资产大类")
    private String category;
    @Schema(description = "资产归属")
    private String owner;
    @Schema(description = "状态|草稿draft、已上架online、已下架offline")
    private String status;
    @Schema(description = "描述")
    private String description;
    @Schema(description = "用户手册")
    private String docUrl;
    @Schema(description = "资产操作api")
    private List<ApiInfo> apiList;
    @Schema(description = "OpenApi")
    private List<ApiInfo> openApiList;

    @Schema(description = "元数据信息")
    private JSONObject metadata;
    @Schema(description = "依赖定义")
    private List<JSONObject> dependencyRule;
    @Schema(description = "管理上下文定义")
    private List<JSONObject> manageContextRule;
    @Schema(description = "数据收集配置")
    private JSONObject dataCollectConfig;

    private Map<String, MultiLanguageDTO<String>> lang;
    @Schema(description = "被关联的设计器信息")
    private List<RelationDesignerInfo> relationDesignerInfos = new ArrayList<>();
    @Schema(description = "发布的时间")
    private Date publishTime;

    private String icon;

    /**
     * 能否引用
     */
    private Boolean canReference = false;
    /**
     * 能否复制
     */
    private Boolean canCopy = false;
    private JSONObject rowDataPermission;

    private Date createDate;

    public static AssetTypeResDto create(AssetType assetType) {
        AssetTypeResDto assetTypeResDto = new AssetTypeResDto();
        BeanUtils.copyProperties(assetType,assetTypeResDto);
        return assetTypeResDto;
    }


    public static void sort(List<AssetTypeResDto> list) {
        list.sort(Comparator.comparingLong(AssetTypeResDto::obtainShowSort));
    }

    /**
     * @return 在默认的添加顺序基础上，调低已下架的优先级
     */
    public long obtainShowSort() {
        return OnlineState.isOff(getStatus())
                ? Long.MAX_VALUE : Long.MAX_VALUE - getCreateDate().getTime();
    }
}
