package com.digiwin.athena.dto.assetType;

import com.digiwin.athena.bo.assembly.Designer;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import lombok.Data;

import java.util.Map;

@Data
public class RelationDesignerInfo{


    private String objId;
    private String name;
    private String type;

    private Boolean read=false;
    private Boolean write=false;

    private Map<String, MultiLanguageDTO<String>> lang;

    public static RelationDesignerInfo create(Designer d) {
        RelationDesignerInfo relationDesignerInfo = new RelationDesignerInfo();
        relationDesignerInfo.setObjId(d.getId());
        relationDesignerInfo.setName(d.getName());
        relationDesignerInfo.setType(d.getType());
        relationDesignerInfo.setLang(d.getLang());

        return relationDesignerInfo;
    }
}
