package com.digiwin.athena.integration.assembly.gmc.dto.commodity;

import com.digiwin.athena.utils.user.UserHelper;
import lombok.Data;

/**
 * 创建商品请求参数
 */
@Data
public class CreateCommodityRequest {

    private String sysId;

    private String platformCode;

    private Integer paymentType;

    private String tenancyPeriod;

    /**
     * 團隊類型(teamId) = 4.开发伙伴 時 設定為 ISV商品(ODM),  其他团队类型为 lcdp
     */
    private String productCode;

    private String usersNumber;

    /**
     * 商品U数品号
     */
    private String userNumberCode;

    private Boolean showConsole;

    private String pmEmails;


    /**
     * 构建创建商品请求
     *
     * @param appId       应用ID
     * @param productCode 商品类别（ODM/lcdp）
     * @return 创建商品请求对象
     */
    public static CreateCommodityRequest build(String appId, String productCode) {

        CreateCommodityRequest request = new CreateCommodityRequest();

        request.setSysId(appId);
        request.setPlatformCode("Athena");
        // 人/月
        request.setPaymentType(1);
        request.setTenancyPeriod("12");
        request.setProductCode(productCode);
        // 商品.銷售方案.基礎用戶數
        request.setUsersNumber("50");
        request.setUserNumberCode("0");
        request.setShowConsole(false);
        request.setPmEmails(UserHelper.getCurrentUserNameOrSystem());

        return request;
    }

}
