package com.digiwin.athena.integration.assembly.gmc.dto.commodity;

import cn.hutool.core.collection.ListUtil;
import com.digiwin.athena.convertor.BaseConverter;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * 更新商品模组请求参数
 */
@Data
public class UpdateModulesRequest {

    private String code;

    private ModulesInfo modules;

    private List<MultiLanguageResource> multiLanguageResource;


    /**
     * 构建更新模组请求
     *
     * @param appId 应用ID
     * @param appName 应用名称
     * @param curAppToken 应用token
     * @param moduleList 模组列表
     * @return 更新模组请求对象
     */
    public static UpdateModulesRequest build(
            String appId, String appName, String curAppToken, List<ModulesInfo.ModuleItem> moduleList) {

        ModulesInfo.AppInfo appInfo = new ModulesInfo.AppInfo();
        appInfo.setCategoryId(appId);
        appInfo.setId(appId);
        appInfo.setName(appName);
        appInfo.setIsMultiLogin(0);

        ModulesInfo modulesInfo = new ModulesInfo();
        modulesInfo.setAppToken(curAppToken);
        modulesInfo.setApp(appInfo);
        modulesInfo.setModules(moduleList);
        modulesInfo.setActions(new ArrayList<>());

        MultiLanguageResource.LanguageData customUnit = new MultiLanguageResource.LanguageData();
        customUnit.setFieldName("customunit");
        customUnit.setContent("次");

        MultiLanguageResource.LanguageData goodsName = new MultiLanguageResource.LanguageData();
        goodsName.setFieldName("goodsName");
        goodsName.setContent(appName);

        MultiLanguageResource.LanguageData modulesJSON = new MultiLanguageResource.LanguageData();
        modulesJSON.setFieldName("modules");
        modulesJSON.setContent(BaseConverter.INSTANCE.serialize(modulesInfo));

        MultiLanguageResource zhCNLanguage = new MultiLanguageResource();
        zhCNLanguage.setLanguage("zh-CN");
        zhCNLanguage.setData(ListUtil.toList(customUnit, goodsName, modulesJSON));

        UpdateModulesRequest request = new UpdateModulesRequest();
        request.setCode(appId);
        request.setModules(modulesInfo);
        request.setMultiLanguageResource(ListUtil.toList(zhCNLanguage));

        return request;
    }
}
