package com.digiwin.athena.integration.assembly.iam.api;


import cn.hutool.http.HttpUtil;
import com.digiwin.athena.config.AssemblyProp;
import com.digiwin.athena.constant.IamConstant;
import com.digiwin.athena.convertor.BaseConverter;
import com.digiwin.athena.http.iam.dto.ResultDto;
import com.digiwin.athena.integration.assembly.iam.dto.application.IamCreateApplicationRequest;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

@Component
@RequiredArgsConstructor
public class IamApplicationApi {
    private final AssemblyProp assemblyProp;

    /**
     * @return appSid
     */
    public ResultDto<Long> createApplication(String appToken, String iamToken, IamCreateApplicationRequest appRequest) {
        // TODO pzz 改为openFeign
        String url = assemblyProp.getIamDomain() + IamConstant.createApplication;

        String response = HttpUtil.createPost(url)
                .body(BaseConverter.INSTANCE.serialize(appRequest))
                .header("digi-middleware-auth-user", iamToken)
                .header("digi-middleware-auth-app", appToken)
                .execute()
                .body();

        return BaseConverter.INSTANCE.deserialize(response, ResultDto.class, Long.class);
    }
}
