package com.digiwin.athena.mongodb.domain;

import com.digiwin.athena.utils.user.UserHelper;

import java.time.LocalDateTime;
import java.util.Map;

public interface BaseMongoEntity<K> {
    K getId();

    String getCreateBy();

    void setCreateBy(String user);

    String getEditBy();

    void setEditBy(String user);


    LocalDateTime getCreateTime();

    void setCreateTime(LocalDateTime time);

    LocalDateTime getEditTime();

    void setEditTime(LocalDateTime time);


    static void prepareSave(Map<String, Object> entityMap) {
        String userName = UserHelper.getCurrentUserNameOrSystem();
        LocalDateTime time = LocalDateTime.now();

        if (entityMap.get("_id") == null) {
            entityMap.put("createBy", userName);
            entityMap.put("createTime", time);
        }

        entityMap.put("editBy", userName);
        entityMap.put("editTime", userName);
    }

    default void prepareSave() {
        String userName = UserHelper.getCurrentUserNameOrSystem();
        LocalDateTime time = LocalDateTime.now();

        if (getId() == null) {
            setCreateBy(userName);
            setCreateTime(time);
        }

        setEditBy(userName);
        setEditTime(time);
    }
}
