package com.digiwin.athena.mongodb.domain.application;

import com.digiwin.athena.dto.action.MultiLanguageDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.io.Serial;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 资产定义
 */
@Data
@Document(collection = "asset")
public class Asset {

    //草稿draft、effect-生效
    public static final String ADP_STATUS_DRAFT = "draft";
    public static final String ADP_STATUS_EFFECT = "effect";

    @Id
    private String objectId;
    // 资产唯一标识
    private String assetId;
    // 资产类型
    private String type;
    // 业务标识，由各个设计器创建资产时填写, 非唯一
    private String code;

    // 具体资产内容，可根据配置进行检索，如："task":[{"code" : "start_PM_f468894210000dc4"}]
    private Map<String, List<Map<String,Object>>> content;

    /**
     *  资产来源|SD-独立资产，CB-组合资产
     */
    private String source;

    /**
     * 业务数据
     */
    private String businessData;

    private String createBy;
    private String editBy;
    private Date createDate;
    private Date editDate;

    private String assetName;

    private Asset.ManageContext manageContext = new Asset.ManageContext();
    private ShowField showFields = new ShowField();
    private Map<String, MultiLanguageDTO> lang = new HashMap<>();

    private String depResolveError;

    @Deprecated
    private String adpRemark;
    /**
     * 状态|draft-草稿，effect-生效
     */
    @Deprecated
    private String adpStatus;
    @Deprecated
    private String sourceBranch;
    // 所属应用，非必填
    @Deprecated
    private String application;

    /**
     * 版本号,没有多版本，默认就是0
     */
    @Deprecated
    private String adpVersion="0";

    /**
     * 备注序列号
     */
    @Deprecated
    private Integer adpRemarkNumber;

    /**
     * 管理上下文内部类
     * 继承HashMap以支持动态字段,同时提供默认字段的访问方法
     */
    @EqualsAndHashCode(callSuper = true)
    @FieldNameConstants
    @NoArgsConstructor
    @Data
    public static class ManageContext extends HashMap<String, Object> {
        @Serial
        private static final long serialVersionUID = 1L;

        private String dataId;
        private String application;
        private String branch;

        private String adpVersion;
        private String adpStatus;
        private String target;

        public ManageContext(Map<String, Object> m) {
            super(m);
        }

        public String getApplication() {
            Object value = this.get(Fields.application);
            return value != null ? String.valueOf(value) : null;
        }

        public void setApplication(String application) {
            this.application = application;
            this.put(Fields.application, application);
        }

        public String getBranch() {
            Object value = this.get(Fields.branch);
            return value != null ? String.valueOf(value) : null;
        }

        public void setBranch(String branch) {
            this.branch = branch;
            this.put(Fields.branch, branch);
        }

        public String getAdpVersion() {
            Object value = this.get(Fields.adpVersion);
            return value != null ? String.valueOf(value) : null;
        }

        public void setAdpVersion(String adpVersion) {
            this.adpVersion = adpVersion;
            this.put(Fields.adpVersion, adpVersion);
        }

        public String getAdpStatus() {
            Object value = this.get(Fields.adpStatus);
            return value != null ? String.valueOf(value) : null;
        }

        public void setAdpStatus(String adpStatus) {
            this.adpStatus = adpStatus;
            this.put(Fields.adpStatus, adpStatus);
        }

        public String getTarget() {
            Object value = this.get(Fields.target);
            return value != null ? String.valueOf(value) : null;
        }

        public void setTarget(String target) {
            this.target = target;
            this.put(Fields.target, target);
        }

        public String getDataId() {
            Object value = this.get(Fields.dataId);
            return value != null ? String.valueOf(value) : null;
        }

        public void setDataId(String dataId) {
            this.dataId = dataId;
            this.put(Fields.dataId, dataId);
        }
    }

    @Data
    public static class ShowField{
        private String adpRemark;
        private Integer adpRemarkNumber;
        private String versionDescription;
    }
}
