package com.digiwin.athena.service.assembly;

import com.digiwin.athena.dto.assembly.application.ApplicationDataRespDTO;
import com.digiwin.athena.dto.assembly.application.ApplicationDataSaveDTO;

/**
 * 应用数据服务接口
 */
public interface ApplicationDataService {

    /**
     * 保存应用数据
     *
     * @param saveDTO 保存请求DTO
     */
    void save(ApplicationDataSaveDTO saveDTO);

    /**
     * 根据应用编码查询应用数据
     *
     * @param appCode 应用编码
     * @return 应用数据响应DTO，如果不存在返回null
     */
    ApplicationDataRespDTO getByAppCode(String appCode);
}
