package com.digiwin.athena.service.assembly.impl;

import com.digiwin.athena.dao.mongodao.assembly.ApplicationDataMongoDao;
import com.digiwin.athena.dto.assembly.application.ApplicationDataRespDTO;
import com.digiwin.athena.dto.assembly.application.ApplicationDataSaveDTO;
import com.digiwin.athena.mongodb.domain.assembly.ApplicationData;
import com.digiwin.athena.service.assembly.ApplicationDataService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 应用数据服务实现
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ApplicationDataServiceImpl implements ApplicationDataService {

    private final ApplicationDataMongoDao applicationDataMongoDao;

    @Transactional(rollbackFor = Throwable.class)
    @Override
    public void save(ApplicationDataSaveDTO saveDTO) {
        log.info("保存应用数据，appCode: {}", saveDTO.getAppCode());

        // 查询是否已存在
        ApplicationData existing = applicationDataMongoDao.selectByAppCode(saveDTO.getAppCode());

        ApplicationData applicationData;
        if (existing != null) {
            // 更新已有数据
            existing.setData(saveDTO.getData());
            applicationData = existing;
        } else {
            // 创建新数据
            applicationData = new ApplicationData();
            applicationData.setAppCode(saveDTO.getAppCode());
            applicationData.setData(saveDTO.getData());
        }

        applicationDataMongoDao.save(applicationData);
        log.info("应用数据保存成功，appCode: {}", saveDTO.getAppCode());
    }

    @Override
    public ApplicationDataRespDTO getByAppCode(String appCode) {
        log.debug("查询应用数据，appCode: {}", appCode);
        ApplicationDataRespDTO respDTO = new ApplicationDataRespDTO();

        ApplicationData applicationData = applicationDataMongoDao.selectByAppCode(appCode);
        if (applicationData == null) {
            return respDTO;
        }

        respDTO.setData(applicationData.getData());
        return respDTO;
    }
}
