package com.digiwin.athena.service.asset;

import com.digiwin.athena.dto.asset.AssetInfoDto;
import com.digiwin.athena.dto.businessData.BusinessDataDto;
import com.digiwin.athena.mongodb.domain.application.Asset;
import com.digiwin.athena.mongodb.domain.application.AssetDefinition;
import com.digiwin.athena.mongodb.domain.application.AssetRelation;

import java.util.List;
import java.util.Map;

public interface AssetBusinessDataAction<T> {
    AssetDefinition.AssetTypeEnum getAssetType();

    /**
     * 获取这个版本资产的最新业务数据
     * @param asset
     * @return
     */
    AssetInfoDto loadBusinessData(AssetInfoDto asset);

    /**
     * 在内存中复制资产数据到指定应用
     * @param businessDataDto
     * @param toApplication
     * @param specifyingParam 指定的新增的code参数
     */
    void replaceBusinessDataToApplication(BusinessDataDto businessDataDto, String toApplication, Map<String,Object> specifyingParam);

    /**
     * 执行新增
     * @param businessDataDto
     */
    void insertBusinessDataToApplication(BusinessDataDto businessDataDto);

    /**
     * 获取引用关联的全部业务数据
     * @return
     */
    T getRefBusiness(List<AssetRelation> allAssetRelations , List<Asset> assetList);
}
