/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.common.dict;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReflectUtil;
import com.digiwin.athena.constants.enums.BaseLangEnum;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Target(value={ElementType.FIELD, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Component
public @interface Dict {
    public Class<?> enumClass() default Void.class;

    public static class Translator {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(Translator.class);

        public static void translate(Object obj) {
            Field[] fields;
            if (obj == null) {
                return;
            }
            Class<?> clazz = obj.getClass();
            Map beanProperties = BeanUtil.getPropertyDescriptorMap(clazz, (boolean)false);
            if (beanProperties == null || beanProperties.isEmpty()) {
                return;
            }
            for (Field field : fields = ReflectUtil.getFields(clazz)) {
                try {
                    Translator.translate(obj, field, beanProperties);
                }
                catch (Exception e) {
                    if (log.isTraceEnabled()) {
                        log.trace("\u5b57\u5178\u7ffb\u8bd1\u5f02\u5e38\uff01", (Throwable)e);
                        continue;
                    }
                    log.warn("\u5b57\u5178\u7ffb\u8bd1\u5f02\u5e38\uff01msg:{}", (Object)e.getMessage());
                }
            }
        }

        protected static void translate(Object obj, Field field, Map<String, PropertyDescriptor> beanProperties) {
            Dict dictAnnotation = (Dict)AnnotationUtil.getAnnotation((AnnotatedElement)field, Dict.class);
            if (dictAnnotation == null) {
                return;
            }
            PropertyDescriptor prop = beanProperties.get(field.getName());
            if (prop == null) {
                return;
            }
            Object fieldVal = ReflectUtil.invoke((Object)obj, (Method)prop.getReadMethod(), (Object[])new Object[0]);
            Class<?> enumClass = dictAnnotation.enumClass();
            if (BaseLangEnum.class.isAssignableFrom(enumClass)) {
                Object langObj = ReflectUtil.invoke((Object)obj, (Method)beanProperties.get("lang").getReadMethod(), (Object[])new Object[0]);
                Translator.translateLangEnum(langObj, enumClass, prop, fieldVal);
            } else {
                log.warn("\u6682\u4e0d\u652f\u6301\u7684\u5b57\u5178\u6ce8\u89e3\u8f6c\u4e49\u65b9\u5f0f\uff01annotation:{}", (Object)dictAnnotation);
            }
        }

        protected static <K> void translateLangEnum(Object langVal, Class<? extends BaseLangEnum<?>> enumClass, PropertyDescriptor prop, Object fieldVal) {
            if (!(langVal instanceof Map)) {
                return;
            }
            Map langMap = (Map)langVal;
            if (langMap.containsKey(prop.getName())) {
                return;
            }
            BaseLangEnum<?> enumValue = BaseLangEnum.byCodeObj(enumClass, fieldVal);
            if (enumValue == null) {
                return;
            }
            langMap.put(prop.getName(), enumValue.buildMultiLangDto());
        }
    }
}

