/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.constants.enums;

import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import java.util.Objects;

public interface BaseLangEnum<K> {
    public static <K, T extends BaseLangEnum<K>> T byCodeObj(Class<T> enumClass, Object code) {
        for (BaseLangEnum enumConstant : (BaseLangEnum[])enumClass.getEnumConstants()) {
            if (!enumConstant.codeObjEquals(code)) continue;
            return (T)enumConstant;
        }
        return null;
    }

    public K getCode();

    public String getDescZhCn();

    public String getDescZhTw();

    public String getDescEnUs();

    default public boolean codeObjEquals(Object compareCode) {
        if (compareCode == null) {
            return false;
        }
        K code = this.getCode();
        if (code.getClass().isInstance(compareCode)) {
            return code.equals(compareCode);
        }
        String compareCodeStr = StrUtil.toStringOrNull((Object)compareCode);
        String codeStr = StrUtil.toStringOrNull(code);
        return Objects.equals(codeStr, compareCodeStr);
    }

    default public boolean codeEquals(K compareCode) {
        K code = this.getCode();
        return code.equals(compareCode);
    }

    default public MultiLanguageDTO<String> buildMultiLangDto() {
        MultiLanguageDTO multiLangDto = new MultiLanguageDTO();
        multiLangDto.setZh_CN((Object)this.getDescZhCn());
        multiLangDto.setZh_TW((Object)this.getDescZhTw());
        multiLangDto.setEn_US((Object)this.getDescEnUs());
        return multiLangDto;
    }
}

