/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.controller.assembly;

import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.assembly.application.ApplicationDataRespDTO;
import com.digiwin.athena.dto.assembly.application.ApplicationDataSaveDTO;
import com.digiwin.athena.service.assembly.ApplicationDataService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/assembly/application/"})
@Validated
@Tag(name="\u5e94\u7528\u7ba1\u7406", description="\u63d0\u4f9b\u5e94\u7528\u6570\u636e\u7684\u4fdd\u5b58\u548c\u67e5\u8be2\u63a5\u53e3")
public class AssemblyApplicationController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssemblyApplicationController.class);
    private final ApplicationDataService applicationDataService;

    @PostMapping(value={"/data/save"})
    @Operation(summary="\u4fdd\u5b58\u5e94\u7528\u6570\u636e", description="\u4fdd\u5b58\u6216\u66f4\u65b0\u5e94\u7528\u7684\u89e3\u51b3\u65b9\u6848\u6570\u636e")
    public ResultDto<Void> save(@Valid @RequestBody ApplicationDataSaveDTO saveDTO) {
        log.info("\u6536\u5230\u4fdd\u5b58\u5e94\u7528\u6570\u636e\u8bf7\u6c42: appCode={}", (Object)saveDTO.getAppCode());
        this.applicationDataService.save(saveDTO);
        return ResultDto.createSuccess(null);
    }

    @GetMapping(value={"/data/byCode/{appCode}"})
    @Operation(summary="\u67e5\u8be2\u5e94\u7528\u6570\u636e", description="\u6839\u636e\u5e94\u7528\u7f16\u7801\u67e5\u8be2\u5e94\u7528\u7684\u89e3\u51b3\u65b9\u6848\u6570\u636e\uff0c\u4e0d\u5b58\u5728\u65f6\u8fd4\u56denull")
    public ResultDto<Map<String, Object>> getByCode(@NotBlank @PathVariable String appCode) {
        log.info("\u6536\u5230\u67e5\u8be2\u5e94\u7528\u6570\u636e\u8bf7\u6c42: appCode={}", (Object)appCode);
        ApplicationDataRespDTO respDTO = this.applicationDataService.getByAppCode(appCode);
        return ResultDto.createSuccess(respDTO.getData());
    }

    @Generated
    public AssemblyApplicationController(ApplicationDataService applicationDataService) {
        this.applicationDataService = applicationDataService;
    }
}

