/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.controller.assembly;

import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.bo.assembly.Designer;
import com.digiwin.athena.convertor.assembly.DesignerConvertor;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.assembly.designer.DesignerDetailDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerListDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerPageQo;
import com.digiwin.athena.dto.assembly.designer.DesignerSaveDTO;
import com.digiwin.athena.service.ManageBackgroundUserService;
import com.digiwin.athena.service.assembly.impl.DDesignerServiceImpl;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/assembly/designer/d/"})
@Validated
public class DDesignerController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DDesignerController.class);
    private final DDesignerServiceImpl designerService;
    private final ManageBackgroundUserService manageBackgroundUserService;

    @PostMapping(value={"/list"})
    public ResultDto<Pagination<DesignerListDTO>> list(@RequestBody PageReqCondition<DesignerPageQo> pageReqCondition) {
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        Pagination<DesignerListDTO> res = this.designerService.findList(pageReqCondition);
        return ResultDto.createSuccess(res);
    }

    @PostMapping(value={"/save"})
    public ResultDto<DesignerDetailDTO> createDesignTimeDesigner(@Valid @RequestBody DesignerSaveDTO param) {
        log.info("\u6536\u5230\u521b\u5efa\u8bbe\u8ba1\u65f6\u6001\u8bbe\u8ba1\u5668\u8bf7\u6c42: {}", (Object)param);
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        Designer bo = this.designerService.save(param);
        return ResultDto.createSuccess((Object)DesignerConvertor.INSTANCE.toDto(bo));
    }

    @GetMapping(value={"/{id}/delete"})
    public ResultDto<Void> deleteDesignTimeDesigner(@NotBlank @PathVariable String id) {
        log.info("\u6536\u5230\u5220\u9664\u8bbe\u8ba1\u65f6\u6001\u8bbe\u8ba1\u5668\u8bf7\u6c42: {}", (Object)id);
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        this.designerService.deleteById(id);
        return ResultDto.createSuccess(null);
    }

    @GetMapping(value={"/{id}"})
    public ResultDto<DesignerDetailDTO> getDesignTimeDesignerDetail(@NotBlank @PathVariable String id) {
        log.debug("\u6536\u5230\u83b7\u53d6\u8bbe\u8ba1\u65f6\u6001\u8bbe\u8ba1\u5668\u8be6\u60c5\u8bf7\u6c42: {}", (Object)id);
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        return ResultDto.createSuccess((Object)this.designerService.findDetailById(id));
    }

    @GetMapping(value={"/{id}/publish"})
    public ResultDto<Void> publishDesigner(@NotBlank @PathVariable String id) {
        log.info("\u6536\u5230\u53d1\u5e03\u8bbe\u8ba1\u5668\u8bf7\u6c42: {}", (Object)id);
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        this.designerService.publish(id);
        return ResultDto.createSuccess(null);
    }

    @GetMapping(value={"/{id}/offline"})
    public ResultDto<Void> offlineDesigner(@NotBlank @PathVariable String id) {
        log.info("\u6536\u5230\u4e0b\u67b6\u8bbe\u8ba1\u5668\u8bf7\u6c42: {}", (Object)id);
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        this.designerService.takeDown(id);
        return ResultDto.createSuccess(null);
    }

    @GetMapping(value={"/{id}/online"})
    public ResultDto<Void> onlineDesigner(@NotBlank @PathVariable String id) {
        log.info("\u6536\u5230\u4e0a\u67b6\u8bbe\u8ba1\u5668\u8bf7\u6c42: {}", (Object)id);
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        this.designerService.launch(id);
        return ResultDto.createSuccess(null);
    }

    @GetMapping(value={"/validate/unique"})
    public ResultDto<Boolean> validateDesignerCodeUnique(@RequestParam(required=false) String code, @RequestParam(required=false) String name, @RequestParam(required=false) String excludeObjectId) {
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        log.debug("\u6536\u5230\u9a8c\u8bc1\u8bbe\u8ba1\u5668\u7f16\u7801\u552f\u4e00\u6027\u8bf7\u6c42: {}", (Object)code);
        boolean isUnique = this.designerService.validateUnique(code, name, excludeObjectId);
        return ResultDto.createSuccess((Object)isUnique);
    }

    @GetMapping(value={"/list/published"})
    public ResultDto<List<DesignerListDTO>> listPublished() {
        log.debug("\u6536\u5230\u83b7\u53d6\u5df2\u53d1\u5e03\u8bbe\u8ba1\u5668\u5217\u8868\u8bf7\u6c42");
        List<DesignerListDTO> res = this.designerService.findPublishedList();
        return ResultDto.createSuccess(res);
    }

    @Generated
    public DDesignerController(DDesignerServiceImpl designerService, ManageBackgroundUserService manageBackgroundUserService) {
        this.designerService = designerService;
        this.manageBackgroundUserService = manageBackgroundUserService;
    }
}

