/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.controller.assembly;

import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.convertor.assembly.SolutionConvertor;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanDetailDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanListDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanPageQo;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanSaveDTO;
import com.digiwin.athena.service.ManageBackgroundUserService;
import com.digiwin.athena.service.assembly.impl.DSolutionPlanServiceImpl;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/assembly/solutionPlan/d/"})
@Validated
public class DSolutionPlanController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DSolutionPlanController.class);
    private final DSolutionPlanServiceImpl solutionService;
    private final ManageBackgroundUserService manageBackgroundUserService;

    @PostMapping(value={"/list"})
    public ResultDto<Pagination<SolutionPlanListDTO>> list(@RequestBody PageReqCondition<SolutionPlanPageQo> pageReqCondition) {
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        Pagination<SolutionPlanListDTO> res = this.solutionService.findList(pageReqCondition);
        return ResultDto.createSuccess(res);
    }

    @PostMapping(value={"/save"})
    public ResultDto<SolutionPlanDetailDTO> save(@Valid @RequestBody SolutionPlanSaveDTO param) {
        log.info("\u6536\u5230\u521b\u5efa\u8bbe\u8ba1\u65f6\u6001\u89e3\u51b3\u65b9\u6848\u8bf7\u6c42: {}", (Object)param);
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        SolutionPlan bo = this.solutionService.save(param);
        return ResultDto.createSuccess((Object)SolutionConvertor.INSTANCE.toDto(bo));
    }

    @GetMapping(value={"/{id}/delete"})
    public ResultDto<Void> deleteDesignTimeAssemblyApplicationConfig(@NotBlank @PathVariable String id) {
        log.info("\u6536\u5230\u5220\u9664\u8bbe\u8ba1\u65f6\u6001\u89e3\u51b3\u65b9\u6848\u8bf7\u6c42: {}", (Object)id);
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        this.solutionService.deleteById(id);
        return ResultDto.createSuccess(null);
    }

    @GetMapping(value={"/{id}"})
    public ResultDto<SolutionPlanDetailDTO> getDesignTimeAssemblyApplicationConfigDetail(@NotBlank @PathVariable String id) {
        log.debug("\u6536\u5230\u83b7\u53d6\u8bbe\u8ba1\u65f6\u6001\u89e3\u51b3\u65b9\u6848\u8be6\u60c5\u8bf7\u6c42: {}", (Object)id);
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        return ResultDto.createSuccess((Object)this.solutionService.findDetailById(id));
    }

    @GetMapping(value={"/{id}/publish"})
    public ResultDto<Void> publishAssemblyApplicationConfig(@NotBlank @PathVariable String id) {
        log.info("\u6536\u5230\u53d1\u5e03\u89e3\u51b3\u65b9\u6848\u8bf7\u6c42: {}", (Object)id);
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        this.solutionService.publish(id);
        return ResultDto.createSuccess(null);
    }

    @GetMapping(value={"/{id}/offline"})
    public ResultDto<Void> offlineAssemblyApplicationConfig(@NotBlank @PathVariable String id) {
        log.info("\u6536\u5230\u4e0b\u67b6\u89e3\u51b3\u65b9\u6848\u8bf7\u6c42: {}", (Object)id);
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        this.solutionService.takeDown(id);
        return ResultDto.createSuccess(null);
    }

    @GetMapping(value={"/{id}/online"})
    public ResultDto<Void> onlineAssemblyApplicationConfig(@NotBlank @PathVariable String id) {
        log.info("\u6536\u5230\u4e0a\u67b6\u89e3\u51b3\u65b9\u6848\u8bf7\u6c42: {}", (Object)id);
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        this.solutionService.launch(id);
        return ResultDto.createSuccess(null);
    }

    @GetMapping(value={"/validate/unique"})
    public ResultDto<Boolean> validateAssemblyApplicationConfigCodeUnique(@RequestParam(required=false) String code, @RequestParam(required=false) String name, @RequestParam(required=false) String excludeObjectId) {
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        log.debug("\u6536\u5230\u9a8c\u8bc1\u89e3\u51b3\u65b9\u6848\u7f16\u7801\u552f\u4e00\u6027\u8bf7\u6c42: {}", (Object)code);
        boolean isUnique = this.solutionService.validateUnique(code, name, excludeObjectId);
        return ResultDto.createSuccess((Object)isUnique);
    }

    @GetMapping(value={"/validate/checkIamExists/{type}"})
    public ResultDto<Boolean> validateIamExists(@PathVariable String type) {
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        log.info("\u6536\u5230\u6821\u9a8c\u89e3\u51b3\u65b9\u6848IAM\u5e94\u7528\u662f\u5426\u5b58\u5728\u8bf7\u6c42\uff0ctype: {}", (Object)type);
        Boolean exists = this.solutionService.checkIamExists(type);
        return ResultDto.createSuccess((Object)exists);
    }

    @Generated
    public DSolutionPlanController(DSolutionPlanServiceImpl solutionService, ManageBackgroundUserService manageBackgroundUserService) {
        this.solutionService = solutionService;
        this.manageBackgroundUserService = manageBackgroundUserService;
    }
}

