/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao.mongodao.assembly;

import com.digiwin.athena.mongodb.repository.MongoPrimaryRepositoryDecorator;
import com.digiwin.athena.mongodb.repository.MongoRuntimeRepositoryDecorator;
import com.digiwin.athena.mongodb.repository.MongoUserRepositoryDecorator;
import java.util.function.Supplier;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PublishableContext {
    protected static final ThreadLocal<MongoUserRepositoryDecorator> HOLDER = new ThreadLocal();
    protected static MongoRuntimeRepositoryDecorator runtimeDecorator;
    protected static MongoPrimaryRepositoryDecorator primaryDecorator;

    public static MongoUserRepositoryDecorator getDecorator() {
        MongoUserRepositoryDecorator dao = HOLDER.get();
        return dao != null ? dao : primaryDecorator;
    }

    public static void withRuntime(Runnable runnable) {
        HOLDER.set((MongoUserRepositoryDecorator)runtimeDecorator);
        try {
            runnable.run();
        }
        finally {
            HOLDER.remove();
        }
    }

    public static <T> T withRuntime(Supplier<T> callable) {
        HOLDER.set((MongoUserRepositoryDecorator)runtimeDecorator);
        try {
            T t = callable.get();
            return t;
        }
        finally {
            HOLDER.remove();
        }
    }

    @Autowired
    public void setRuntimeDecorator(MongoRuntimeRepositoryDecorator runtimeDecorator) {
        PublishableContext.runtimeDecorator = runtimeDecorator;
    }

    @Autowired
    public void setPrimaryDecorator(MongoPrimaryRepositoryDecorator primaryDecorator) {
        PublishableContext.primaryDecorator = primaryDecorator;
    }

    @Generated
    public PublishableContext() {
    }
}

