/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao.mongodao.assembly.impl;

import cn.hutool.core.util.ObjectUtil;
import com.digiwin.athena.bo.assembly.Designer;
import com.digiwin.athena.constants.enums.assembly.OnlineState;
import com.digiwin.athena.convertor.assembly.DesignerConvertor;
import com.digiwin.athena.dao.mongodao.assembly.DDesignerMongoDao;
import com.digiwin.athena.dao.mongodao.assembly.PublishableContext;
import com.digiwin.athena.dao.mongodao.assembly.RDesignerMongoDao;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.designer.DesignerListDTO;
import com.digiwin.athena.dto.assembly.designer.RDesignerPageQo;
import com.digiwin.athena.mongodb.domain.assembly.DesignerEntity;
import com.digiwin.athena.mongodb.repository.MongoRuntimeRepositoryDecorator;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class RDesignerMongoDaoImpl
implements RDesignerMongoDao {
    private final MongoRuntimeRepositoryDecorator runtimeDecorator;
    private final DDesignerMongoDao dDesignerMongoDao;

    @Override
    public Designer selectById(String objectId) {
        return PublishableContext.withRuntime(() -> this.dDesignerMongoDao.selectById(objectId));
    }

    @Override
    public Pagination<DesignerListDTO> selectOnlineDesignerPage(PageReqCondition<RDesignerPageQo> pageParam) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").is((Object)OnlineState.Online.getCode()));
        RDesignerPageQo condition = (RDesignerPageQo)ObjectUtil.defaultIfNull((Object)((RDesignerPageQo)pageParam.getCondition()), RDesignerPageQo::new);
        DDesignerMongoDao.addSearchNameOrType(query, condition.getSearchContent());
        return this.runtimeDecorator.findWithPage(query, DesignerEntity.class, pageParam).convert(DesignerConvertor.INSTANCE::toListDTO);
    }

    @Override
    public void save(Designer designer) {
        PublishableContext.withRuntime(() -> this.dDesignerMongoDao.save(designer));
    }

    @Override
    public boolean deleteById(String objectId) {
        return PublishableContext.withRuntime(() -> this.dDesignerMongoDao.deleteById(objectId));
    }

    @Override
    public List<Designer> selectByIds(Collection<String> ids) {
        return PublishableContext.withRuntime(() -> this.dDesignerMongoDao.selectByIds(ids));
    }

    @Generated
    public RDesignerMongoDaoImpl(MongoRuntimeRepositoryDecorator runtimeDecorator, DDesignerMongoDao dDesignerMongoDao) {
        this.runtimeDecorator = runtimeDecorator;
        this.dDesignerMongoDao = dDesignerMongoDao;
    }
}

