/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao.mongodao.assembly.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.constants.enums.assembly.AssemblyType;
import com.digiwin.athena.constants.enums.assembly.OnlineState;
import com.digiwin.athena.convertor.assembly.SolutionConvertor;
import com.digiwin.athena.dao.mongodao.assembly.DDesignerMongoDao;
import com.digiwin.athena.dao.mongodao.assembly.PublishableContext;
import com.digiwin.athena.dao.mongodao.assembly.RSolutionMongoDao;
import com.digiwin.athena.dao.mongodao.assembly.impl.DSolutionMongoDaoImpl;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.solution.RSolutionPlanPageQo;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanListDTO;
import com.digiwin.athena.mongodb.domain.application.ApplicationConfig;
import com.digiwin.athena.mongodb.repository.MongoRuntimeRepositoryDecorator;
import com.digiwin.athena.mongodb.repository.MongoUserRepositoryDecorator;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class RSolutionMongoDaoImpl
implements RSolutionMongoDao {
    protected static final SolutionConvertor CONVERTOR = SolutionConvertor.INSTANCE;
    protected final MongoRuntimeRepositoryDecorator runtimeDecorator;
    protected DSolutionMongoDaoImpl dSolutionMongoDao;

    @Override
    public SolutionPlan selectById(String objectId) {
        return PublishableContext.withRuntime(() -> this.dSolutionMongoDao.selectById(objectId));
    }

    @Override
    public Pagination<SolutionPlanListDTO> selectOnlineSolutionPage(PageReqCondition<RSolutionPlanPageQo> pageParam) {
        Query query = new Query();
        this.commonCondition(query, true);
        RSolutionPlanPageQo condition = (RSolutionPlanPageQo)ObjectUtil.defaultIfNull((Object)((RSolutionPlanPageQo)pageParam.getCondition()), RSolutionPlanPageQo::new);
        if (condition.getIsDynamic() != null) {
            Criteria dynamic = Criteria.where((String)"assemblyType");
            if (condition.getIsDynamic().booleanValue()) {
                dynamic.is((Object)AssemblyType.Dynamic.getCode());
            } else {
                dynamic.is((Object)AssemblyType.Static.getCode());
            }
            query.addCriteria((CriteriaDefinition)dynamic);
        }
        DDesignerMongoDao.addSearchNameOrType(query, condition.getSearchContent());
        return this.getDecorator().findWithPage(query, ApplicationConfig.class, pageParam).convert(SolutionConvertor.INSTANCE::entityToListDTO);
    }

    @Override
    public void save(SolutionPlan solution) {
        PublishableContext.withRuntime(() -> this.dSolutionMongoDao.save(solution));
    }

    @Override
    public boolean deleteById(String objectId) {
        return PublishableContext.withRuntime(() -> this.dSolutionMongoDao.deleteById(objectId));
    }

    @Override
    public List<SolutionPlanListDTO> selectByAppType(Collection<Integer> appTypeList, boolean onlyOnline) {
        Query query = new Query();
        if (CollUtil.isNotEmpty(appTypeList)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"appType").in(appTypeList));
        }
        this.commonCondition(query, onlyOnline);
        return this.getDecorator().find(query, ApplicationConfig.class).stream().map(CONVERTOR::entityToListDTO).collect(Collectors.toList());
    }

    @Override
    public SolutionPlan selectByAppType(Integer appType) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"appType").is((Object)appType));
        ApplicationConfig applicationConfig = (ApplicationConfig)this.getDecorator().findOne(query, ApplicationConfig.class);
        return CONVERTOR.toBO(applicationConfig);
    }

    protected void commonCondition(Query query, boolean onlyOnline) {
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"assemblyType").exists(true).ne(null));
        if (onlyOnline) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").is((Object)OnlineState.Online.getCode()));
        }
    }

    public MongoUserRepositoryDecorator getDecorator() {
        return this.runtimeDecorator;
    }

    @Autowired
    @Lazy
    public void setDSolutionMongoDao(DSolutionMongoDaoImpl dSolutionMongoDao) {
        this.dSolutionMongoDao = dSolutionMongoDao;
    }

    @Generated
    public RSolutionMongoDaoImpl(MongoRuntimeRepositoryDecorator runtimeDecorator) {
        this.runtimeDecorator = runtimeDecorator;
    }
}

