/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datacollect.script;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.utils.JSUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ScriptExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScriptExecutor.class);
    private final ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
    private final ObjectMapper objectMapper;

    public ScriptExecutor(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T> T execute(String script, Object params, Class<T> returnClass) {
        if (StrUtil.isBlank((CharSequence)script)) {
            return null;
        }
        return (T)JSUtil.eval((String)script, (Object)params, returnClass);
    }

    public <T> T convertResult(Object result, Class<T> targetClass) {
        if (result == null) {
            return null;
        }
        if (targetClass.isInstance(result)) {
            return (T)result;
        }
        if (result instanceof String) {
            try {
                return (T)this.objectMapper.readValue((String)result, targetClass);
            }
            catch (Exception e) {
                log.warn("JSON\u53cd\u5e8f\u5217\u5316\u5931\u8d25\uff0c\u5c1d\u8bd5\u4f7f\u7528Convert\u8f6c\u6362\uff0cmsg:{}", (Object)e.getMessage());
                return (T)Convert.convert(targetClass, (Object)result);
            }
        }
        return (T)Convert.convert(targetClass, (Object)result);
    }

    private ScriptEngine createEngine() {
        ScriptEngine engine = this.scriptEngineManager.getEngineByName("javascript");
        if (engine != null) {
            return engine;
        }
        engine = this.scriptEngineManager.getEngineByName("groovy");
        if (engine != null) {
            return engine;
        }
        throw new IllegalStateException("\u6ca1\u6709\u53ef\u7528\u7684\u811a\u672c\u5f15\u64ce\u3002\u8bf7\u6dfb\u52a0Groovy\u6216JavaScript\u5f15\u64ce\u4f9d\u8d56\u3002");
    }
}

