/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dto.asset;

import com.digiwin.athena.mongodb.domain.application.AssetRelation;
import com.digiwin.athena.utils.user.UserHelper;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class AssetRelationInfoDto {
    private String assetId;
    private String application;
    private String adpVersion = "0";
    private String userBranch = "develop";

    public Boolean judgeRequiredFields() {
        return StringUtils.isNotEmpty((CharSequence)this.application) && StringUtils.isNotEmpty((CharSequence)this.adpVersion) && StringUtils.isNotEmpty((CharSequence)this.userBranch);
    }

    public AssetRelation convertAssetRelation() {
        AssetRelation assetRelation = new AssetRelation();
        assetRelation.setAssetId(this.assetId);
        assetRelation.getSource().setApplication(this.application);
        assetRelation.getSource().setAdpVersion(this.adpVersion);
        assetRelation.getSource().setUserBranch(this.userBranch);
        UserHelper.fillCreateInfo((Object)assetRelation);
        UserHelper.fillEditInfo((Object)assetRelation);
        return assetRelation;
    }

    public static AssetRelationInfoDto create(String assetId, String application, String userAdpVersion, String userBranch) {
        AssetRelationInfoDto assetRelationInfoDto = new AssetRelationInfoDto();
        assetRelationInfoDto.setAssetId(assetId);
        assetRelationInfoDto.setApplication(application);
        if (StringUtils.isNotEmpty((CharSequence)userAdpVersion)) {
            assetRelationInfoDto.setAdpVersion(userAdpVersion);
        }
        if (StringUtils.isNotEmpty((CharSequence)userBranch)) {
            assetRelationInfoDto.setUserBranch(userBranch);
        }
        return assetRelationInfoDto;
    }

    @Generated
    public AssetRelationInfoDto() {
    }

    @Generated
    public String getAssetId() {
        return this.assetId;
    }

    @Generated
    public String getApplication() {
        return this.application;
    }

    @Generated
    public String getAdpVersion() {
        return this.adpVersion;
    }

    @Generated
    public String getUserBranch() {
        return this.userBranch;
    }

    @Generated
    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    @Generated
    public void setApplication(String application) {
        this.application = application;
    }

    @Generated
    public void setAdpVersion(String adpVersion) {
        this.adpVersion = adpVersion;
    }

    @Generated
    public void setUserBranch(String userBranch) {
        this.userBranch = userBranch;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetRelationInfoDto)) {
            return false;
        }
        AssetRelationInfoDto other = (AssetRelationInfoDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$assetId = this.getAssetId();
        String other$assetId = other.getAssetId();
        if (this$assetId == null ? other$assetId != null : !this$assetId.equals(other$assetId)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$adpVersion = this.getAdpVersion();
        String other$adpVersion = other.getAdpVersion();
        if (this$adpVersion == null ? other$adpVersion != null : !this$adpVersion.equals(other$adpVersion)) {
            return false;
        }
        String this$userBranch = this.getUserBranch();
        String other$userBranch = other.getUserBranch();
        return !(this$userBranch == null ? other$userBranch != null : !this$userBranch.equals(other$userBranch));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssetRelationInfoDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $assetId = this.getAssetId();
        result = result * 59 + ($assetId == null ? 43 : $assetId.hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $adpVersion = this.getAdpVersion();
        result = result * 59 + ($adpVersion == null ? 43 : $adpVersion.hashCode());
        String $userBranch = this.getUserBranch();
        result = result * 59 + ($userBranch == null ? 43 : $userBranch.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AssetRelationInfoDto(assetId=" + this.getAssetId() + ", application=" + this.getApplication() + ", adpVersion=" + this.getAdpVersion() + ", userBranch=" + this.getUserBranch() + ")";
    }
}

