/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.integration.assembly.facade;

import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.config.AssemblyProp;
import com.digiwin.athena.http.iam.dto.ResultDto;
import com.digiwin.athena.integration.assembly.iam.api.IamApplicationApi;
import com.digiwin.athena.integration.assembly.iam.dto.application.IamCreateApplicationRequest;
import com.digiwin.athena.service.assembly.ApplicationService;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class IamApplicationFacadeService
implements ApplicationService {
    private final AssemblyProp assemblyProp;
    private final IamApplicationApi iamApplicationApi;

    @Override
    public Long createApplication(String iamToken, SolutionPlan solutionPlan) {
        IamCreateApplicationRequest appRequest = IamCreateApplicationRequest.build(solutionPlan, this.assemblyProp.getSolution().getGmcLogoImgUrl());
        ResultDto<Long> responseObj = this.iamApplicationApi.createApplication(this.assemblyProp.getAppToken(), iamToken, appRequest);
        if (responseObj.getSuccess()) {
            return (Long)responseObj.getData();
        }
        throw new BusinessException("IAM failed to create the app, error message:" + responseObj.getMessage());
    }

    @Generated
    public IamApplicationFacadeService(AssemblyProp assemblyProp, IamApplicationApi iamApplicationApi) {
        this.assemblyProp = assemblyProp;
        this.iamApplicationApi = iamApplicationApi;
    }
}

