/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.mq;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datacollect.api.dto.AssetCollectApiResponse;
import com.digiwin.athena.datacollect.context.CollectContext;
import com.digiwin.athena.service.asset.AssetDataCollectService;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnBean(name={"rabbitMQConfig"})
@ConditionalOnProperty(prefix="rabbitmq.mdc", name={"assetDataSyncQueueName"})
public class AssetDataConsumerListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetDataConsumerListener.class);
    private final AssetDataCollectService assetDataCollectService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RabbitListener(containerFactory="manualAckContainerFactory", queues={"${rabbitmq.mdc.assetDataSyncQueueName}"})
    public void mdcMetadataListener(String message, Channel channel, Message msg) throws IOException {
        try {
            AssetCollectApiResponse.AssetDataItem assetDataItem = (AssetCollectApiResponse.AssetDataItem)JSONObject.parseObject((String)message, AssetCollectApiResponse.AssetDataItem.class);
            AssetCollectApiResponse.AssetData data = assetDataItem.getData();
            log.info("Receive message,code={}, type={}, manageContext={}", new Object[]{data.getCode(), data.getType(), JSONObject.toJSONString((Object)data.getManageContext())});
            this.assetDataCollectService.batchProcessDataItems(new CollectContext(), List.of(assetDataItem));
        }
        catch (Exception e) {
            log.error("\u6d88\u8d39\u5f02\u5e38:" + message, (Throwable)e);
        }
        finally {
            channel.basicAck(msg.getMessageProperties().getDeliveryTag(), false);
        }
    }

    @Generated
    public AssetDataConsumerListener(AssetDataCollectService assetDataCollectService) {
        this.assetDataCollectService = assetDataCollectService;
    }
}

