package com.digiwin.athena.convertor.assembly;

import com.digiwin.athena.bo.assembly.Designer;
import com.digiwin.athena.convertor.BaseConverter;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerDetailDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerListDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerSaveDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanBaseDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanDetailDTO;
import com.digiwin.athena.dto.assetType.AssetTypeBaseDTO;
import com.digiwin.athena.mongodb.domain.assembly.DesignerEntity;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.mapstruct.factory.Mappers;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-12-18T15:50:58+0800",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 17.0.8 (Oracle Corporation)"
)
public class DesignerConvertorImpl implements DesignerConvertor {

    private final BaseConverter baseConverter = Mappers.getMapper( BaseConverter.class );

    @Override
    public Designer toBO(DesignerEntity designer) {
        if ( designer == null ) {
            return null;
        }

        Designer designer1 = new Designer();

        designer1.setId( designer.getId() );
        designer1.setType( designer.getType() );
        designer1.setOwner( designer.getOwner() );
        designer1.setName( designer.getName() );
        designer1.setVersion( designer.getVersion() );
        designer1.setVersionSort( designer.getVersionSort() );
        designer1.setStatus( designer.getStatus() );
        designer1.setDescription( designer.getDescription() );
        designer1.setRelatedAssetType( designer.getRelatedAssetType() );
        List<SolutionPlanBaseDTO> list = designer.getRelatedSolutionPlan();
        if ( list != null ) {
            designer1.setRelatedSolutionPlan( new ArrayList<SolutionPlanBaseDTO>( list ) );
        }
        List<DesignerDetailDTO.ApiExecInfoDTO> list1 = designer.getApiList();
        if ( list1 != null ) {
            designer1.setApiList( new ArrayList<DesignerDetailDTO.ApiExecInfoDTO>( list1 ) );
        }
        designer1.setIntegrationType( designer.getIntegrationType() );
        designer1.setIntegrationConfig( designer.getIntegrationConfig() );
        Map<String, MultiLanguageDTO<String>> map = designer.getLang();
        if ( map != null ) {
            designer1.setLang( new LinkedHashMap<String, MultiLanguageDTO<String>>( map ) );
        }
        designer1.setPublishTime( baseConverter.localDateTime2Date( designer.getPublishTime() ) );
        designer1.setPublishBy( designer.getPublishBy() );
        designer1.setCreateTime( designer.getCreateTime() );
        designer1.setEditTime( designer.getEditTime() );
        designer1.setCreateBy( designer.getCreateBy() );
        designer1.setEditBy( designer.getEditBy() );

        return designer1;
    }

    @Override
    public DesignerEntity toPo(Designer designer) {
        if ( designer == null ) {
            return null;
        }

        DesignerEntity designerEntity = new DesignerEntity();

        designerEntity.setId( designer.getId() );
        designerEntity.setType( designer.getType() );
        designerEntity.setOwner( designer.getOwner() );
        designerEntity.setName( designer.getName() );
        designerEntity.setVersion( designer.getVersion() );
        designerEntity.setVersionSort( designer.getVersionSort() );
        designerEntity.setStatus( designer.getStatus() );
        designerEntity.setDescription( designer.getDescription() );
        designerEntity.setRelatedAssetType( designer.getRelatedAssetType() );
        List<SolutionPlanBaseDTO> list = designer.getRelatedSolutionPlan();
        if ( list != null ) {
            designerEntity.setRelatedSolutionPlan( new ArrayList<SolutionPlanBaseDTO>( list ) );
        }
        List<DesignerDetailDTO.ApiExecInfoDTO> list1 = designer.getApiList();
        if ( list1 != null ) {
            designerEntity.setApiList( new ArrayList<DesignerDetailDTO.ApiExecInfoDTO>( list1 ) );
        }
        designerEntity.setIntegrationType( designer.getIntegrationType() );
        designerEntity.setIntegrationConfig( designer.getIntegrationConfig() );
        Map<String, MultiLanguageDTO<String>> map = designer.getLang();
        if ( map != null ) {
            designerEntity.setLang( new LinkedHashMap<String, MultiLanguageDTO<String>>( map ) );
        }
        designerEntity.setPublishTime( baseConverter.date2LocalDateTime( designer.getPublishTime() ) );
        designerEntity.setPublishBy( designer.getPublishBy() );
        designerEntity.setCreateTime( designer.getCreateTime() );
        designerEntity.setEditTime( designer.getEditTime() );
        designerEntity.setCreateBy( designer.getCreateBy() );
        designerEntity.setEditBy( designer.getEditBy() );

        return designerEntity;
    }

    @Override
    public DesignerListDTO toListDTO(DesignerEntity designer) {
        if ( designer == null ) {
            return null;
        }

        DesignerListDTO designerListDTO = new DesignerListDTO();

        List<AssetTypeBaseDTO> read = designerRelatedAssetTypeRead( designer );
        List<AssetTypeBaseDTO> list = read;
        if ( list != null ) {
            designerListDTO.setReadAssetType( new ArrayList<AssetTypeBaseDTO>( list ) );
        }
        List<AssetTypeBaseDTO> write = designerRelatedAssetTypeWrite( designer );
        List<AssetTypeBaseDTO> list1 = write;
        if ( list1 != null ) {
            designerListDTO.setWriteAssetType( new ArrayList<AssetTypeBaseDTO>( list1 ) );
        }
        designerListDTO.setId( designer.getId() );
        designerListDTO.setType( designer.getType() );
        designerListDTO.setOwner( designer.getOwner() );
        designerListDTO.setName( designer.getName() );
        designerListDTO.setVersion( designer.getVersion() );
        designerListDTO.setStatus( designer.getStatus() );
        designerListDTO.setDescription( designer.getDescription() );
        List<SolutionPlanBaseDTO> list2 = designer.getRelatedSolutionPlan();
        if ( list2 != null ) {
            designerListDTO.setRelatedSolutionPlan( new ArrayList<SolutionPlanBaseDTO>( list2 ) );
        }
        designerListDTO.setIntegrationType( designer.getIntegrationType() );
        Map<String, MultiLanguageDTO<String>> map = designer.getLang();
        if ( map != null ) {
            designerListDTO.setLang( new LinkedHashMap<String, MultiLanguageDTO<String>>( map ) );
        }
        designerListDTO.setPublishTime( designer.getPublishTime() );
        designerListDTO.setPublishBy( designer.getPublishBy() );
        designerListDTO.setEditTime( designer.getEditTime() );
        designerListDTO.setEditBy( designer.getEditBy() );

        translateDetail( designerListDTO );

        return designerListDTO;
    }

    @Override
    public Designer toBo(DesignerSaveDTO designer) {
        if ( designer == null ) {
            return null;
        }

        Designer designer1 = new Designer();

        designer1.setId( designer.getId() );
        designer1.setType( designer.getType() );
        designer1.setOwner( designer.getOwner() );
        designer1.setName( designer.getName() );
        designer1.setVersion( designer.getVersion() );
        designer1.setDescription( designer.getDescription() );
        designer1.setRelatedAssetType( designer.getRelatedAssetType() );
        List<SolutionPlanBaseDTO> list = designer.getRelatedSolutionPlan();
        if ( list != null ) {
            designer1.setRelatedSolutionPlan( new ArrayList<SolutionPlanBaseDTO>( list ) );
        }
        List<DesignerDetailDTO.ApiExecInfoDTO> list1 = designer.getApiList();
        if ( list1 != null ) {
            designer1.setApiList( new ArrayList<DesignerDetailDTO.ApiExecInfoDTO>( list1 ) );
        }
        designer1.setIntegrationType( designer.getIntegrationType() );
        designer1.setIntegrationConfig( designer.getIntegrationConfig() );
        Map<String, MultiLanguageDTO<String>> map = designer.getLang();
        if ( map != null ) {
            designer1.setLang( new LinkedHashMap<String, MultiLanguageDTO<String>>( map ) );
        }

        return designer1;
    }

    @Override
    public DesignerDetailDTO toDto(Designer byId) {
        if ( byId == null ) {
            return null;
        }

        DesignerDetailDTO designerDetailDTO = new DesignerDetailDTO();

        designerDetailDTO.setId( byId.getId() );
        designerDetailDTO.setType( byId.getType() );
        designerDetailDTO.setOwner( byId.getOwner() );
        designerDetailDTO.setName( byId.getName() );
        designerDetailDTO.setVersion( byId.getVersion() );
        designerDetailDTO.setStatus( byId.getStatus() );
        designerDetailDTO.setDescription( byId.getDescription() );
        designerDetailDTO.setRelatedAssetType( byId.getRelatedAssetType() );
        List<SolutionPlanBaseDTO> list = byId.getRelatedSolutionPlan();
        if ( list != null ) {
            designerDetailDTO.setRelatedSolutionPlan( new ArrayList<SolutionPlanBaseDTO>( list ) );
        }
        List<DesignerDetailDTO.ApiExecInfoDTO> list1 = byId.getApiList();
        if ( list1 != null ) {
            designerDetailDTO.setApiList( new ArrayList<DesignerDetailDTO.ApiExecInfoDTO>( list1 ) );
        }
        designerDetailDTO.setIntegrationType( byId.getIntegrationType() );
        designerDetailDTO.setIntegrationConfig( byId.getIntegrationConfig() );
        Map<String, MultiLanguageDTO<String>> map = byId.getLang();
        if ( map != null ) {
            designerDetailDTO.setLang( new LinkedHashMap<String, MultiLanguageDTO<String>>( map ) );
        }
        designerDetailDTO.setPublishTime( byId.getPublishTime() );
        designerDetailDTO.setPublishBy( byId.getPublishBy() );
        designerDetailDTO.setCreateTime( byId.getCreateTime() );
        designerDetailDTO.setEditTime( byId.getEditTime() );
        designerDetailDTO.setCreateBy( byId.getCreateBy() );
        designerDetailDTO.setEditBy( byId.getEditBy() );

        translateList( designerDetailDTO );

        return designerDetailDTO;
    }

    @Override
    public void merge(Designer source, Designer target) {
        if ( source == null ) {
            return;
        }

        if ( source.getId() != null ) {
            target.setId( source.getId() );
        }
        if ( source.getType() != null ) {
            target.setType( source.getType() );
        }
        if ( source.getOwner() != null ) {
            target.setOwner( source.getOwner() );
        }
        if ( source.getName() != null ) {
            target.setName( source.getName() );
        }
        if ( source.getVersion() != null ) {
            target.setVersion( source.getVersion() );
        }
        if ( source.getVersionSort() != null ) {
            target.setVersionSort( source.getVersionSort() );
        }
        if ( source.getStatus() != null ) {
            target.setStatus( source.getStatus() );
        }
        if ( source.getDescription() != null ) {
            target.setDescription( source.getDescription() );
        }
        if ( source.getRelatedAssetType() != null ) {
            target.setRelatedAssetType( source.getRelatedAssetType() );
        }
        if ( target.getRelatedSolutionPlan() != null ) {
            List<SolutionPlanBaseDTO> list = source.getRelatedSolutionPlan();
            if ( list != null ) {
                target.getRelatedSolutionPlan().clear();
                target.getRelatedSolutionPlan().addAll( list );
            }
        }
        else {
            List<SolutionPlanBaseDTO> list = source.getRelatedSolutionPlan();
            if ( list != null ) {
                target.setRelatedSolutionPlan( new ArrayList<SolutionPlanBaseDTO>( list ) );
            }
        }
        if ( target.getApiList() != null ) {
            List<DesignerDetailDTO.ApiExecInfoDTO> list1 = source.getApiList();
            if ( list1 != null ) {
                target.getApiList().clear();
                target.getApiList().addAll( list1 );
            }
        }
        else {
            List<DesignerDetailDTO.ApiExecInfoDTO> list1 = source.getApiList();
            if ( list1 != null ) {
                target.setApiList( new ArrayList<DesignerDetailDTO.ApiExecInfoDTO>( list1 ) );
            }
        }
        if ( source.getIntegrationType() != null ) {
            target.setIntegrationType( source.getIntegrationType() );
        }
        if ( source.getIntegrationConfig() != null ) {
            target.setIntegrationConfig( source.getIntegrationConfig() );
        }
        if ( target.getLang() != null ) {
            Map<String, MultiLanguageDTO<String>> map = source.getLang();
            if ( map != null ) {
                target.getLang().clear();
                target.getLang().putAll( map );
            }
        }
        else {
            Map<String, MultiLanguageDTO<String>> map = source.getLang();
            if ( map != null ) {
                target.setLang( new LinkedHashMap<String, MultiLanguageDTO<String>>( map ) );
            }
        }
        if ( source.getPublishTime() != null ) {
            target.setPublishTime( source.getPublishTime() );
        }
        if ( source.getPublishBy() != null ) {
            target.setPublishBy( source.getPublishBy() );
        }
        if ( source.getCreateTime() != null ) {
            target.setCreateTime( source.getCreateTime() );
        }
        if ( source.getEditTime() != null ) {
            target.setEditTime( source.getEditTime() );
        }
        if ( source.getCreateBy() != null ) {
            target.setCreateBy( source.getCreateBy() );
        }
        if ( source.getEditBy() != null ) {
            target.setEditBy( source.getEditBy() );
        }
    }

    @Override
    public SolutionPlanDetailDTO.DesignerBaseInfoDTO toBaseInfoDTO(Designer designer) {
        if ( designer == null ) {
            return null;
        }

        SolutionPlanDetailDTO.DesignerBaseInfoDTO designerBaseInfoDTO = new SolutionPlanDetailDTO.DesignerBaseInfoDTO();

        designerBaseInfoDTO.setId( designer.getId() );
        designerBaseInfoDTO.setType( designer.getType() );
        designerBaseInfoDTO.setName( designer.getName() );
        Map<String, MultiLanguageDTO<String>> map = designer.getLang();
        if ( map != null ) {
            designerBaseInfoDTO.setLang( new LinkedHashMap<String, MultiLanguageDTO<String>>( map ) );
        }

        return designerBaseInfoDTO;
    }

    @Override
    public List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> toBaseInfoDTOList(List<Designer> designers) {
        if ( designers == null ) {
            return null;
        }

        List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> list = new ArrayList<SolutionPlanDetailDTO.DesignerBaseInfoDTO>( designers.size() );
        for ( Designer designer : designers ) {
            list.add( toBaseInfoDTO( designer ) );
        }

        return list;
    }

    @Override
    public Map<String, SolutionPlanDetailDTO.DesignerBaseInfoDTO> toBaseInfoMap(Map<String, Designer> designerMap) {
        if ( designerMap == null ) {
            return null;
        }

        Map<String, SolutionPlanDetailDTO.DesignerBaseInfoDTO> map = new LinkedHashMap<String, SolutionPlanDetailDTO.DesignerBaseInfoDTO>( Math.max( (int) ( designerMap.size() / .75f ) + 1, 16 ) );

        for ( java.util.Map.Entry<String, Designer> entry : designerMap.entrySet() ) {
            String key = entry.getKey();
            SolutionPlanDetailDTO.DesignerBaseInfoDTO value = toBaseInfoDTO( entry.getValue() );
            map.put( key, value );
        }

        return map;
    }

    private List<AssetTypeBaseDTO> designerRelatedAssetTypeRead(DesignerEntity designerEntity) {
        if ( designerEntity == null ) {
            return null;
        }
        DesignerDetailDTO.RelatedAssetTypeDTO relatedAssetType = designerEntity.getRelatedAssetType();
        if ( relatedAssetType == null ) {
            return null;
        }
        List<AssetTypeBaseDTO> read = relatedAssetType.getRead();
        if ( read == null ) {
            return null;
        }
        return read;
    }

    private List<AssetTypeBaseDTO> designerRelatedAssetTypeWrite(DesignerEntity designerEntity) {
        if ( designerEntity == null ) {
            return null;
        }
        DesignerDetailDTO.RelatedAssetTypeDTO relatedAssetType = designerEntity.getRelatedAssetType();
        if ( relatedAssetType == null ) {
            return null;
        }
        List<AssetTypeBaseDTO> write = relatedAssetType.getWrite();
        if ( write == null ) {
            return null;
        }
        return write;
    }
}
