package com.digiwin.athena.datacollect.context;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.Map;

/**
 * HTTP脚本执行上下文
 * 扩展基础上下文，添加HTTP相关的请求和响应信息
 */
@Getter
@Setter
@ToString
@EqualsAndHashCode(callSuper = true)
public class HttpRequestContext extends BaseScriptContext {

    /**
     * 请求URL
     */
    private String url;

    /**
     * 请求体
     */
    private Object requestBody;

    /**
     * 请求头
     */
    private Map<String, Object> requestHeader;

    /**
     * 响应status
     */
    private Integer responseStatusCode;

    private boolean responseSuccess;

    private String responseBodyStr;

    /**
     * 响应体
     */
    private Object responseBody;

    /**
     * 响应头
     */
    private Map<String, String> responseHeader;

    public HttpRequestContext() {
        super(null);
    }

    public HttpRequestContext(String url, CollectContext collectContext) {
        super(collectContext);
        this.url = url;
    }
}
