/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.assembly.impl;

import cn.hutool.core.collection.CollStreamUtil;
import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.bo.assembly.Designer;
import com.digiwin.athena.constants.enums.assembly.OnlineState;
import com.digiwin.athena.convertor.assembly.DesignerConvertor;
import com.digiwin.athena.convertor.assembly.SolutionConvertor;
import com.digiwin.athena.dao.mongodao.assembly.DDesignerMongoDao;
import com.digiwin.athena.dao.mongodao.assembly.PublishableContext;
import com.digiwin.athena.dao.mongodao.assembly.RDesignerMongoDao;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.designer.DesignerDetailDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerListDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerPageQo;
import com.digiwin.athena.dto.assembly.designer.DesignerSaveDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanListDTO;
import com.digiwin.athena.dto.assetType.AssetTypeBaseDTO;
import com.digiwin.athena.dto.assetType.AssetTypeResDto;
import com.digiwin.athena.service.SyncRuntime;
import com.digiwin.athena.service.assembly.DDesignerService;
import com.digiwin.athena.service.assembly.RSolutionPlanService;
import com.digiwin.athena.service.assetType.RAssetTypeService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DDesignerServiceImpl
extends SyncRuntime<Designer>
implements DDesignerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DDesignerServiceImpl.class);
    protected final DDesignerMongoDao dDesignerMongoDao;
    protected final RDesignerMongoDao rDesignerMongoDao;
    protected RSolutionPlanService rSolutionPlanService;
    protected RAssetTypeService rAssetTypeService;
    protected DDesignerServiceImpl proxyThis;

    @Override
    public Pagination<DesignerListDTO> findList(PageReqCondition<DesignerPageQo> param) {
        Pagination<DesignerListDTO> pagination = this.dDesignerMongoDao.selectPage(param);
        this.fillNewestSolutionPlan(pagination.getData());
        this.fillNewestAssetType(pagination.getData());
        return pagination;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void save(Designer updated) {
        log.info("\u5f00\u59cb\u521b\u5efa\u8bbe\u8ba1\u65f6\u6001\u8bbe\u8ba1\u5668: {}", (Object)updated.getName());
        updated.validateTypeFormat();
        this.checkUnique(updated);
        String objectId = updated.getId();
        if (objectId != null) {
            Designer existingBo = this.findExist(objectId);
            existingBo.overwriteUnmodifiable(updated);
        } else {
            updated.prepareNew();
        }
        this.dDesignerMongoDao.save(updated);
        log.info("\u6210\u529f\u521b\u5efa\u8bbe\u8ba1\u65f6\u6001\u8bbe\u8ba1\u5668: {}", (Object)updated.getId());
    }

    protected void pureSave(Designer designer) {
        this.dDesignerMongoDao.save(designer);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Designer save(DesignerSaveDTO designer) {
        Designer bo = DesignerConvertor.INSTANCE.toBo(designer);
        this.save(bo);
        return bo;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void deleteById(String objectId) {
        log.info("\u5f00\u59cb\u5220\u9664\u8bbe\u8ba1\u65f6\u6001\u8bbe\u8ba1\u5668: {}", (Object)objectId);
        Designer existingBo = this.findExist(objectId);
        existingBo.checkDelete();
        this.dDesignerMongoDao.deleteById(objectId);
        log.info("\u6210\u529f\u5220\u9664\u8bbe\u8ba1\u65f6\u6001\u8bbe\u8ba1\u5668: {}", (Object)objectId);
    }

    protected void checkUnique(Designer designer) {
        if (!this.validateUnique(designer.getType(), null, designer.getId())) {
            throw new BusinessException(Integer.valueOf(30000), "\u7c7b\u578b\u5df2\u5b58\u5728\uff01");
        }
        if (!this.validateUnique(null, designer.getName(), designer.getId())) {
            throw new BusinessException(Integer.valueOf(30000), "\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
    }

    protected Designer findExist(String objectId) {
        return Optional.ofNullable(this.dDesignerMongoDao.selectById(objectId)).orElseThrow(() -> new BusinessException(Integer.valueOf(30101), "\u8bbe\u8ba1\u5668\u4e0d\u5b58\u5728\uff01", new Object[]{objectId}));
    }

    @Override
    public DesignerDetailDTO findDetailById(String designerId) {
        Map<String, List<SolutionPlanListDTO>> solutionMap = this.rSolutionPlanService.findBaseListByDesignerId(CollUtil.toList((Object[])new String[]{designerId}));
        DesignerDetailDTO dto = DesignerConvertor.INSTANCE.toDto(this.findById(designerId));
        dto.setRelatedSolutionPlan(SolutionConvertor.INSTANCE.toBaseDTO(solutionMap.get(designerId)));
        this.fillNewestAssetType(dto);
        return dto;
    }

    @Override
    public Designer findById(String objectId) {
        log.debug("\u67e5\u8be2\u8bbe\u8ba1\u65f6\u6001\u8bbe\u8ba1\u5668\u8be6\u60c5: {}", (Object)objectId);
        return this.dDesignerMongoDao.selectById(objectId);
    }

    protected void fillNewestAssetType(DesignerDetailDTO designer) {
        DesignerDetailDTO.RelatedAssetTypeDTO relatedAssetType = designer.getRelatedAssetType();
        List<String> asstTypeIdList = designer.obtainAssetTypeIdList();
        List<AssetTypeResDto> assetTypes = this.rAssetTypeService.getAssetTypes(asstTypeIdList);
        Map assetTypeIdMap = CollStreamUtil.toIdentityMap(assetTypes, AssetTypeResDto::getObjId);
        relatedAssetType.setWrite(AssetTypeBaseDTO.sort(relatedAssetType.getWrite(), assetTypeIdMap));
        relatedAssetType.setRead(AssetTypeBaseDTO.sort(relatedAssetType.getRead(), assetTypeIdMap));
    }

    protected void fillNewestAssetType(List<DesignerListDTO> designers) {
        List<String> asstTypeIdList = DesignerListDTO.obtainAssetTypeIdList(designers);
        List<AssetTypeResDto> assetTypes = this.rAssetTypeService.getAssetTypes(asstTypeIdList);
        Map assetTypeIdMap = CollStreamUtil.toIdentityMap(assetTypes, AssetTypeResDto::getObjId);
        designers.forEach(designer -> {
            designer.setWriteAssetType(AssetTypeBaseDTO.sort(designer.getWriteAssetType(), assetTypeIdMap));
            designer.setReadAssetType(AssetTypeBaseDTO.sort(designer.getReadAssetType(), assetTypeIdMap));
        });
    }

    protected void fillNewestSolutionPlan(List<DesignerListDTO> list) {
        List<String> designerIds = DesignerListDTO.obtainIdList(list);
        Map<String, List<SolutionPlanListDTO>> solutionMap = this.rSolutionPlanService.findBaseListByDesignerId(designerIds);
        for (DesignerListDTO designer : list) {
            List<SolutionPlanListDTO> solutionPlan = solutionMap.get(designer.getId());
            designer.setRelatedSolutionPlan(SolutionConvertor.INSTANCE.toBaseDTO(solutionPlan));
        }
    }

    @Override
    public boolean validateUnique(String code, String name, String excludeObjectId) {
        return !this.dDesignerMongoDao.existsByKey(code, name, excludeObjectId);
    }

    @Override
    public List<DesignerListDTO> findPublishedList() {
        PageReqCondition param = new PageReqCondition();
        param.setPageNum(Integer.valueOf(1));
        param.setPageSize(Integer.valueOf(9999));
        param.setCondition((Object)new DesignerPageQo());
        ((DesignerPageQo)param.getCondition()).setStatusList(OnlineState.publishedCode());
        return PublishableContext.withRuntime(() -> this.findList((PageReqCondition<DesignerPageQo>)param).getData());
    }

    @Override
    public List<Designer> findWritableDesignersByIds(List<String> ids) {
        return this.dDesignerMongoDao.selectWritableDesignersByIds(ids);
    }

    @Override
    protected void saveDesignerTimeData(Designer syncData) {
        this.pureSave(syncData);
    }

    @Override
    protected void insertRunTimeData(Designer syncData) {
        this.rDesignerMongoDao.save(syncData);
    }

    @Override
    protected void saveRunTimeData(Designer syncData) {
        this.rDesignerMongoDao.save(syncData);
    }

    @Override
    protected Designer getDesignerTimeData(String objId) {
        return this.proxyThis.findById(objId);
    }

    @Override
    protected Designer getRunTimeData(String objId) {
        return this.rDesignerMongoDao.selectById(objId);
    }

    @Override
    protected void deleteRuntimeData(String objId) {
        this.rDesignerMongoDao.deleteById(objId);
    }

    @Autowired
    @Lazy
    public void setProxyThis(DDesignerServiceImpl proxyThis) {
        this.proxyThis = proxyThis;
    }

    @Autowired
    @Lazy
    public void seRSolutionPlanService(RSolutionPlanService rSolutionPlanService) {
        this.rSolutionPlanService = rSolutionPlanService;
    }

    @Autowired
    @Lazy
    public void setRAssetTypeService(RAssetTypeService rAssetTypeService) {
        this.rAssetTypeService = rAssetTypeService;
    }

    @Generated
    public DDesignerServiceImpl(DDesignerMongoDao dDesignerMongoDao, RDesignerMongoDao rDesignerMongoDao) {
        this.dDesignerMongoDao = dDesignerMongoDao;
        this.rDesignerMongoDao = rDesignerMongoDao;
    }
}

