/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao.mongodao.assembly.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.convertor.assembly.SolutionConvertor;
import com.digiwin.athena.dao.mongodao.assembly.DDesignerMongoDao;
import com.digiwin.athena.dao.mongodao.assembly.DSolutionMongoDao;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanDetailDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanListDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanPageQo;
import com.digiwin.athena.mongodb.domain.application.ApplicationConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.mapping.FieldName;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DSolutionMongoDaoImpl
implements DSolutionMongoDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DSolutionMongoDaoImpl.class);
    private static final SolutionConvertor CONVERTOR = SolutionConvertor.INSTANCE;

    @Override
    public SolutionPlan selectById(String objectId) {
        ApplicationConfig entity = (ApplicationConfig)this.getDecorator().findById((Object)objectId, ApplicationConfig.class);
        return CONVERTOR.toBO(entity);
    }

    @Override
    public SolutionPlan selectByCode(String code) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"type").is((Object)code));
        ApplicationConfig entity = (ApplicationConfig)this.getDecorator().findOne(query, ApplicationConfig.class);
        return CONVERTOR.toBO(entity);
    }

    @Override
    public SolutionPlan selectByName(String name) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"name").is((Object)name));
        ApplicationConfig entity = (ApplicationConfig)this.getDecorator().findOne(query, ApplicationConfig.class);
        return CONVERTOR.toBO(entity);
    }

    @Override
    public void save(SolutionPlan solution) {
        ApplicationConfig entity = CONVERTOR.toEntity(solution);
        entity.prepareSave();
        Map<String, Object> mergeJson = solution.getMergeJson();
        if (Boolean.TRUE.equals(solution.getIsStdPublish()) && CollUtil.isNotEmpty(mergeJson)) {
            String collectionName = this.getDecorator().getCollectionNameFromDocumentAnnotedClass(ApplicationConfig.class);
            Map<String, Object> entityMap = entity.mergeToEntityMap();
            this.getDecorator().save(entityMap, collectionName);
            solution.setId(MapUtil.getStr(entityMap, (Object)FieldName.ID.name()));
        } else {
            this.getDecorator().save((Object)entity);
            solution.setId(entity.getId());
        }
    }

    @Override
    public Integer getNextAppType(int base) {
        Query query = new Query();
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"appType"}));
        query.limit(1);
        ApplicationConfig maxEntity = (ApplicationConfig)this.getDecorator().findOne(query, ApplicationConfig.class);
        if (maxEntity == null || maxEntity.getAppType() == null) {
            return base + 1;
        }
        return Math.max(base, maxEntity.getAppType()) + 1;
    }

    @Override
    public boolean deleteById(String objectId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)FieldName.ID.name()).is((Object)objectId));
        long count = this.getDecorator().remove(query, ApplicationConfig.class);
        return count > 0L;
    }

    @Override
    public boolean existsByKey(String code, String name, String excludeId) {
        Assert.isFalse((boolean)StrUtil.isAllBlank((CharSequence[])new CharSequence[]{code, name}), (String)"code or name can not be null", (Object[])new Object[0]);
        Query query = new Query();
        if (StrUtil.isNotBlank((CharSequence)code)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)code));
        }
        if (StrUtil.isNotBlank((CharSequence)name)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"name").is((Object)name));
        }
        if (excludeId != null) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)FieldName.ID.name()).ne((Object)excludeId));
        }
        return this.getDecorator().count(query, ApplicationConfig.class) > 0L;
    }

    @Override
    public Pagination<SolutionPlanListDTO> selectPage(PageReqCondition<SolutionPlanPageQo> pageParam) {
        Query query = new Query();
        this.buildPageCondition(pageParam, query);
        return this.getDecorator().findWithPage(query, ApplicationConfig.class, pageParam).convert(SolutionConvertor.INSTANCE::entityToListDTO);
    }

    protected void buildPageCondition(PageReqCondition<SolutionPlanPageQo> pageParam, Query query) {
        SolutionPlanPageQo condition = (SolutionPlanPageQo)ObjectUtil.defaultIfNull((Object)((SolutionPlanPageQo)pageParam.getCondition()), SolutionPlanPageQo::new);
        DDesignerMongoDao.addSearchNameOrType(query, condition.getSearchContent());
        if (CollUtil.isNotEmpty(condition.getAssemblyTypeList())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"assemblyType").in(condition.getAssemblyTypeList()));
        }
        if (StrUtil.isNotBlank((CharSequence)condition.getCategory())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"category").is((Object)condition.getCategory()));
        }
        if (CollUtil.isNotEmpty(condition.getSolutionStateList())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").in(condition.getSolutionStateList()));
        }
    }

    @Override
    public Map<String, List<SolutionPlanListDTO>> findListByDesignerId(Iterable<String> designerIdColl) {
        LinkedHashSet<String> designerIdSet = new LinkedHashSet<String>();
        designerIdColl.forEach(designerIdSet::add);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"designerList.id").in(designerIdSet));
        query.with(Sort.by((String[])new String[]{"createTime"}).ascending());
        List solutionList = this.getDecorator().find(query, ApplicationConfig.class);
        return this.groupByDesignerId(solutionList, designerIdSet);
    }

    protected Map<String, List<SolutionPlanListDTO>> groupByDesignerId(List<ApplicationConfig> solutionList, Set<String> inDesignerIdSet) {
        HashMap designerSolutionMap = MapUtil.newHashMap((int)inDesignerIdSet.size());
        for (ApplicationConfig solution : solutionList) {
            for (SolutionPlanDetailDTO.DesignerBaseInfoDTO designerInfo : CollUtil.emptyIfNull(solution.getDesignerList())) {
                if (!inDesignerIdSet.contains(designerInfo.getId())) continue;
                designerSolutionMap.computeIfAbsent(designerInfo.getId(), k -> new ArrayList()).add(solution);
            }
        }
        return MapUtil.map((Map)designerSolutionMap, (k, v) -> SolutionConvertor.INSTANCE.entitySetToListDTO((List<ApplicationConfig>)v));
    }

    @Generated
    public DSolutionMongoDaoImpl() {
    }
}

