/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dto.assetType;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.dto.assetType.AssetTypeResDto;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class AssetTypeBaseDTO {
    private String objId;
    private String type;
    private String name;
    private Map<String, MultiLanguageDTO<String>> lang;

    public static AssetTypeBaseDTO from(AssetTypeResDto v) {
        if (v == null) {
            return null;
        }
        AssetTypeBaseDTO dto = new AssetTypeBaseDTO();
        dto.setObjId(v.getObjId());
        dto.setType(v.getType());
        dto.setName(v.getName());
        dto.setLang(v.getLang());
        return dto;
    }

    public static List<AssetTypeBaseDTO> sort(List<AssetTypeBaseDTO> list, Map<String, AssetTypeResDto> assetTypeIdMap) {
        return CollUtil.emptyIfNull(list).stream().map(v -> assetTypeIdMap.computeIfAbsent(v.getObjId(), k -> v.toAssetTypeResDto())).sorted(Comparator.comparingLong(AssetTypeResDto::obtainShowSort)).map(AssetTypeBaseDTO::from).toList();
    }

    public AssetTypeResDto toAssetTypeResDto() {
        AssetTypeResDto dto = new AssetTypeResDto();
        dto.setObjId(this.getObjId());
        dto.setType(this.getType());
        dto.setName(this.getName());
        dto.setLang(this.getLang());
        return dto;
    }

    @Generated
    public AssetTypeBaseDTO() {
    }

    @Generated
    public String getObjId() {
        return this.objId;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, MultiLanguageDTO<String>> getLang() {
        return this.lang;
    }

    @Generated
    public void setObjId(String objId) {
        this.objId = objId;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setLang(Map<String, MultiLanguageDTO<String>> lang) {
        this.lang = lang;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetTypeBaseDTO)) {
            return false;
        }
        AssetTypeBaseDTO other = (AssetTypeBaseDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$objId = this.getObjId();
        String other$objId = other.getObjId();
        if (this$objId == null ? other$objId != null : !this$objId.equals(other$objId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, MultiLanguageDTO<String>> this$lang = this.getLang();
        Map<String, MultiLanguageDTO<String>> other$lang = other.getLang();
        return !(this$lang == null ? other$lang != null : !((Object)this$lang).equals(other$lang));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssetTypeBaseDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $objId = this.getObjId();
        result = result * 59 + ($objId == null ? 43 : $objId.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, MultiLanguageDTO<String>> $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : ((Object)$lang).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AssetTypeBaseDTO(objId=" + this.getObjId() + ", type=" + this.getType() + ", name=" + this.getName() + ", lang=" + this.getLang() + ")";
    }
}

