/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.assembly.impl;

import cn.hutool.core.net.url.UrlBuilder;
import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.dao.mongodao.assembly.PublishableContext;
import com.digiwin.athena.dao.mongodao.assembly.RSolutionMongoDao;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.solution.RSolutionPlanPageQo;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanDetailDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanListDTO;
import com.digiwin.athena.service.assembly.RSolutionPlanService;
import com.digiwin.athena.service.assembly.RVariableService;
import com.digiwin.athena.service.assembly.impl.DSolutionPlanServiceImpl;
import com.digiwin.athena.service.assembly.impl.DVariableServiceImpl;
import com.digiwin.athena.utils.RequestShareUtil;
import com.digiwin.athena.utils.expression.ExpressionResolver;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class RSolutionPlanServiceImpl
implements RSolutionPlanService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RSolutionPlanServiceImpl.class);
    protected final RSolutionMongoDao rSolutionMongoDao;
    protected final RVariableService rVariableService;
    protected final ExpressionResolver expressionResolver;
    protected DSolutionPlanServiceImpl dSolutionPlanService;

    @Override
    public Pagination<SolutionPlanListDTO> list(PageReqCondition<RSolutionPlanPageQo> pageReqCondition) {
        return this.rSolutionMongoDao.selectOnlineSolutionPage(pageReqCondition);
    }

    @Override
    public List<SolutionPlanListDTO> findByAppTypeOrAll(List<Integer> appType) {
        return this.findByAppTypeOrAll(appType, true);
    }

    @Override
    public List<SolutionPlanListDTO> findByAppTypeOrAll(List<Integer> appType, boolean onlyOnline) {
        return this.rSolutionMongoDao.selectByAppType(new HashSet<Integer>(appType), onlyOnline);
    }

    @Override
    public SolutionPlan findByAppType(Integer appType) {
        return this.rSolutionMongoDao.selectByAppType(appType);
    }

    @Override
    public Map<String, List<SolutionPlanListDTO>> findBaseListByDesignerId(List<String> designerIds) {
        return PublishableContext.withRuntime(() -> this.dSolutionPlanService.findBaseListByDesignerId(designerIds));
    }

    @Override
    public SolutionPlanDetailDTO findDetailById(String id) {
        return PublishableContext.withRuntime(() -> this.dSolutionPlanService.findDetailById(id));
    }

    @Override
    public String resolveSsoUrl(SolutionPlanDetailDTO.SsoConfigDTO ssoConfig) {
        if (ssoConfig == null) {
            return null;
        }
        Map contextMap = (Map)RequestShareUtil.computeIfAbsent((String)"SolutionPlan_Sso_Context", k -> this.rVariableService.getRuntimeVarMap(DVariableServiceImpl.VarKey.SolutionPlan_Sso.key()));
        Map<String, Object> paramMap = ssoConfig.toParamMap(arg_0 -> ((ExpressionResolver)this.expressionResolver).wrapVarName(arg_0));
        Map resolvedMap = this.expressionResolver.resolveMap(paramMap, (Object)contextMap, new String[0]);
        resolvedMap.forEach(contextMap::putIfAbsent);
        String url = this.expressionResolver.resolveToStr(ssoConfig.getUrl(), (Object)contextMap);
        UrlBuilder urlBuilder = UrlBuilder.ofHttp((String)url);
        resolvedMap.forEach((arg_0, arg_1) -> ((UrlBuilder)urlBuilder).addQuery(arg_0, arg_1));
        return urlBuilder.build();
    }

    @Autowired
    @Lazy
    public void setDSolutionPlanService(DSolutionPlanServiceImpl dSolutionPlanService) {
        this.dSolutionPlanService = dSolutionPlanService;
    }

    @Generated
    public RSolutionPlanServiceImpl(RSolutionMongoDao rSolutionMongoDao, RVariableService rVariableService, ExpressionResolver expressionResolver) {
        this.rSolutionMongoDao = rSolutionMongoDao;
        this.rVariableService = rVariableService;
        this.expressionResolver = expressionResolver;
    }
}

