/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.asset.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.actuator.HttpActuator;
import com.digiwin.athena.actuator.HttpExecuteConfig;
import com.digiwin.athena.config.AssetCenterRegisterConfig;
import com.digiwin.athena.dao.mongodao.ApplicationMongoDao;
import com.digiwin.athena.dao.mongodao.asset.AssetDefinitionMongoDao;
import com.digiwin.athena.dao.mongodao.asset.AssetDepInfoMongoDao;
import com.digiwin.athena.dao.mongodao.asset.AssetMongoDao;
import com.digiwin.athena.dao.mongodao.asset.AssetRelationMongoDao;
import com.digiwin.athena.dao.mongodao.assetType.RAssetTypeMongoDao;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.TenantInfo;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.dto.asset.AssetBatchOpenReqDto;
import com.digiwin.athena.dto.asset.AssetCenterInfoResDto;
import com.digiwin.athena.dto.asset.AssetDetailResDto;
import com.digiwin.athena.dto.asset.AssetInfoDto;
import com.digiwin.athena.dto.asset.AssetInfoResDto;
import com.digiwin.athena.dto.asset.AssetOpenReqDto;
import com.digiwin.athena.dto.asset.AssetPagination;
import com.digiwin.athena.dto.asset.AssetRelationAppInfoResDto;
import com.digiwin.athena.dto.asset.AssetRelationInfoDto;
import com.digiwin.athena.dto.asset.AssetReqDto;
import com.digiwin.athena.dto.asset.CreateAssetReqDto;
import com.digiwin.athena.dto.asset.DepAssetResDto;
import com.digiwin.athena.dto.asset.DependentAssetResDto;
import com.digiwin.athena.dto.asset.DesignerAssetListReqDto;
import com.digiwin.athena.dto.asset.UpdateAssetBasicInfoReqDto;
import com.digiwin.athena.dto.asset.UseAssetListReqDto;
import com.digiwin.athena.dto.assetType.ThirdPartyAssetReqDto;
import com.digiwin.athena.enums.VersionStatusEnum;
import com.digiwin.athena.http.asset.PermissionConditionResDto;
import com.digiwin.athena.http.asset.PermissionResDto;
import com.digiwin.athena.http.asset.ThirdPartyApiHelper;
import com.digiwin.athena.mongodb.domain.DependencyRule;
import com.digiwin.athena.mongodb.domain.ExecuteConfig;
import com.digiwin.athena.mongodb.domain.application.Application;
import com.digiwin.athena.mongodb.domain.application.Asset;
import com.digiwin.athena.mongodb.domain.application.AssetDefinition;
import com.digiwin.athena.mongodb.domain.application.AssetDepInfo;
import com.digiwin.athena.mongodb.domain.application.AssetRelation;
import com.digiwin.athena.mongodb.domain.assetType.AssetType;
import com.digiwin.athena.mysql.domain.user.UserPO;
import com.digiwin.athena.service.AssetInit;
import com.digiwin.athena.service.assembly.RVariableService;
import com.digiwin.athena.service.asset.AssetBusinessDataAction;
import com.digiwin.athena.service.asset.AssetCenter;
import com.digiwin.athena.service.codeStandard.BuildGeneratorCodeUtil;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.digiwin.athena.utils.JSUtil;
import com.digiwin.athena.utils.user.UserHelper;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class AssetCenterImpl
implements AssetCenter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetCenterImpl.class);
    private AssetMongoDao assetMongoDao;
    private BuildGeneratorCodeUtil buildGeneratorCodeUtil;
    private AssetRelationMongoDao assetRelationMongoDao;
    private AssetDefinitionMongoDao assetDefinitionMongoDao;
    private AssetCenterRegisterConfig assetCenterRegisterConfig;
    @Resource
    private ThreadPoolExecutor assetCenterPool;
    private ApplicationMongoDao applicationMongoDao;
    @Autowired
    private RAssetTypeMongoDao rAssetTypeMongoDao;
    @Autowired
    @Lazy
    private AssetInit assetInit;
    @Autowired
    private ThirdPartyApiHelper thirdPartyApiHelper;
    @Autowired
    private AssetDepInfoMongoDao assetDepInfoMongoDao;
    @Autowired
    private HttpActuator httpActuator;
    @Autowired
    private RVariableService variableService;

    @Autowired
    public void setApplicationMongoDao(ApplicationMongoDao applicationMongoDao) {
        this.applicationMongoDao = applicationMongoDao;
    }

    @Autowired
    public void setAssetCenterRegisterConfig(AssetCenterRegisterConfig assetCenterRegisterConfig) {
        this.assetCenterRegisterConfig = assetCenterRegisterConfig;
    }

    @Autowired
    public void setAssetDefinitionMongoDao(AssetDefinitionMongoDao assetDefinitionMongoDao) {
        this.assetDefinitionMongoDao = assetDefinitionMongoDao;
    }

    @Autowired
    public void setAssetRelationMongoDao(AssetRelationMongoDao assetRelationMongoDao) {
        this.assetRelationMongoDao = assetRelationMongoDao;
    }

    @Autowired
    public void setBuildGeneratorCodeUtil(BuildGeneratorCodeUtil buildGeneratorCodeUtil) {
        this.buildGeneratorCodeUtil = buildGeneratorCodeUtil;
    }

    @Autowired
    public void setAssetMongoDao(AssetMongoDao assetMongoDao) {
        this.assetMongoDao = assetMongoDao;
    }

    @Override
    public String saveDTDAsset(AssetInfoDto assetInfoDto) {
        Asset asset;
        Assert.isTrue((boolean)assetInfoDto.judgeSaveRequiredFields(), (String)"\u9700\u8981\u8865\u5145\u5fc5\u586b\u5b57\u6bb5");
        AssetDefinition oldAssetDefinition = this.assetDefinitionMongoDao.selectByApplicationAndCode(assetInfoDto.getCode(), assetInfoDto.getApplication());
        if (oldAssetDefinition == null) {
            Asset existAsset = this.assetMongoDao.selectAssetIdByCodeAndApplication(assetInfoDto.getCode(), assetInfoDto.getApplication());
            oldAssetDefinition = assetInfoDto.convertAssetDefinition();
            oldAssetDefinition.setAssetId(existAsset != null ? existAsset.getAssetId() : this.buildGeneratorCodeUtil.createAssetId(assetInfoDto.getCode(), AssetDefinition.AssetTypeEnum.DTD.getCode()));
            oldAssetDefinition.setType(AssetDefinition.AssetTypeEnum.DTD.getCode());
            oldAssetDefinition.setPublisher(CurThreadInfoUtils.getCurTokenTenant().getTenantId());
            oldAssetDefinition.setPublisherName(CurThreadInfoUtils.getCurTokenTenant().getTenantName());
            UserHelper.fillCreateInfo((Object)oldAssetDefinition);
            UserHelper.fillEditInfo((Object)oldAssetDefinition);
            this.assetDefinitionMongoDao.insert(oldAssetDefinition);
        }
        if (VersionStatusEnum.RUN_STATE == assetInfoDto.assetAdpStatus()) {
            this.assetMongoDao.updateDraftAdpStatusByAssetId(UserHelper.getCurrentUser().getName(), oldAssetDefinition.getAssetId());
        }
        if ((asset = this.assetMongoDao.selectByAssetIdAndSourceBranchAndAdpVersion(oldAssetDefinition.getAssetId(), assetInfoDto.getSourceBranch(), assetInfoDto.getAdpVersion())) == null) {
            asset = assetInfoDto.convertAsset();
            asset.setAssetId(oldAssetDefinition.getAssetId());
            asset.setType(oldAssetDefinition.getType());
            UserHelper.fillCreateInfo((Object)asset);
            UserHelper.fillEditInfo((Object)asset);
            this.assetMongoDao.insert(asset);
        } else {
            asset.setContent(assetInfoDto.getContent());
            if (assetInfoDto.getBusinessData() != null) {
                asset.setBusinessData(JSONObject.toJSONString((Object)assetInfoDto.getBusinessData()));
            }
            asset.getManageContext().setAdpStatus(assetInfoDto.assetAdpStatus().getCode());
            asset.getShowFields().setAdpRemarkNumber(assetInfoDto.getAdpRemarkNumber());
            UserHelper.fillEditInfo((Object)asset);
            this.assetMongoDao.save(asset);
        }
        AssetType assetType = this.rAssetTypeMongoDao.selectByType(AssetDefinition.AssetTypeEnum.DTD.getCode());
        this.resolveDepInfo(asset, assetType, null);
        return oldAssetDefinition.getAssetId();
    }

    @Override
    public String saveWorkbenchAsset(AssetInfoDto assetInfoDto) {
        Asset asset;
        Assert.isTrue((boolean)assetInfoDto.judgeSaveRequiredFields(), (String)"\u9700\u8981\u8865\u5145\u5fc5\u586b\u5b57\u6bb5");
        AssetDefinition oldAssetDefinition = this.assetDefinitionMongoDao.selectByApplicationAndCode(assetInfoDto.getCode(), assetInfoDto.getApplication());
        if (oldAssetDefinition == null) {
            Asset existAsset = this.assetMongoDao.selectAssetIdByCodeAndApplication(assetInfoDto.getCode(), assetInfoDto.getApplication());
            oldAssetDefinition = assetInfoDto.convertAssetDefinition();
            oldAssetDefinition.setAssetId(existAsset != null ? existAsset.getAssetId() : this.buildGeneratorCodeUtil.createAssetId(assetInfoDto.getCode(), AssetDefinition.AssetTypeEnum.WORKBENCH.getCode()));
            oldAssetDefinition.setType(AssetDefinition.AssetTypeEnum.WORKBENCH.getCode());
            oldAssetDefinition.setPublisher(CurThreadInfoUtils.getCurTokenTenant().getTenantId());
            oldAssetDefinition.setPublisherName(CurThreadInfoUtils.getCurTokenTenant().getTenantName());
            UserHelper.fillCreateInfo((Object)oldAssetDefinition);
            UserHelper.fillEditInfo((Object)oldAssetDefinition);
            this.assetDefinitionMongoDao.insert(oldAssetDefinition);
        }
        if (VersionStatusEnum.RUN_STATE.getCode().equals(assetInfoDto.assetAdpStatus())) {
            this.assetMongoDao.updateDraftAdpStatusByAssetId(UserHelper.getCurrentUser().getName(), oldAssetDefinition.getAssetId());
        }
        if ((asset = this.assetMongoDao.selectByAssetIdAndSourceBranchAndAdpVersion(oldAssetDefinition.getAssetId(), assetInfoDto.getSourceBranch(), assetInfoDto.getAdpVersion())) == null) {
            asset = assetInfoDto.convertAsset();
            asset.setAssetId(oldAssetDefinition.getAssetId());
            asset.setType(oldAssetDefinition.getType());
            UserHelper.fillCreateInfo((Object)asset);
            UserHelper.fillEditInfo((Object)asset);
            this.assetMongoDao.insert(asset);
        } else {
            asset.setContent(assetInfoDto.getContent());
            asset.setAssetName(assetInfoDto.getAssetName());
            if (assetInfoDto.getBusinessData() != null) {
                asset.setBusinessData(JSONObject.toJSONString((Object)assetInfoDto.getBusinessData()));
            }
            asset.getManageContext().setAdpStatus(assetInfoDto.assetAdpStatus().getCode());
            asset.getShowFields().setAdpRemarkNumber(assetInfoDto.getAdpRemarkNumber());
            UserHelper.fillEditInfo((Object)asset);
            this.assetMongoDao.save(asset);
        }
        return oldAssetDefinition.getAssetId();
    }

    @Override
    public void bindRelation(AssetRelationInfoDto assetRelationInfoDto) {
        Assert.isTrue((boolean)assetRelationInfoDto.judgeRequiredFields(), (String)"\u9700\u8981\u8865\u5145\u5fc5\u586b\u5b57\u6bb5");
        List<Asset> assets = this.assetMongoDao.selectByAssetId(assetRelationInfoDto.getAssetId());
        Assert.isTrue((!assets.isEmpty() ? 1 : 0) != 0, (String)"\u8d44\u4ea7\u6ca1\u6709\u7248\u672c\uff0c\u65e0\u6cd5\u5f15\u7528");
        Asset asset = assets.get(0);
        AssetRelation existAssetRelation = this.assetRelationMongoDao.selectByAssetIdAndAdpVersionAndUserBranchAndApplication(assetRelationInfoDto);
        Assert.isNull((Object)existAssetRelation, (String)"\u5df2\u7ecf\u5f15\u7528\u8fc7\u8fd9\u4e2a\u8d44\u4ea7");
        AssetDefinition assetDefinition = this.assetDefinitionMongoDao.selectByAssetId(assetRelationInfoDto.getAssetId());
        if (assetDefinition == null) {
            Application application = this.applicationMongoDao.selectByCode(asset.getManageContext().getApplication());
            assetDefinition = AssetInfoDto.create(asset).convertAssetDefinition();
            assetDefinition.setAssetId(asset.getAssetId());
            assetDefinition.setType(AssetDefinition.AssetTypeEnum.DTD.getCode());
            assetDefinition.setPublisherName("SYSTEM");
            assetDefinition.setPublisher("SYSTEM");
            assetDefinition.setAdpTenantId(application == null && StringUtils.isEmpty((CharSequence)application.getTenantId()) ? "SYSTEM" : application.getTenantId());
            UserHelper.fillCreateInfo((Object)assetDefinition);
            UserHelper.fillEditInfo((Object)assetDefinition);
            this.assetDefinitionMongoDao.insert(assetDefinition);
        }
        Assert.isTrue((assetDefinition != null ? 1 : 0) != 0, (String)(assetRelationInfoDto.getAssetId() + "\u4e0d\u5b58\u5728"));
        AssetRelation assetRelation = assetRelationInfoDto.convertAssetRelation();
        assetRelation.setBizType(assetDefinition.getType());
        assetRelation.setType(asset.getManageContext().getApplication().equals(assetRelationInfoDto.getApplication()) ? AssetRelation.BelongTypeEnum.OWN_TYPE.getType() : AssetRelation.BelongTypeEnum.REF_TYPE.getType());
        this.assetRelationMongoDao.insert(assetRelation);
        if (!asset.getManageContext().getApplication().equals(assetRelationInfoDto.getApplication())) {
            assetDefinition.setReferencedCount(assetDefinition.getReferencedCount() + 1);
            this.assetDefinitionMongoDao.save(assetDefinition);
        }
    }

    @Override
    public List<Asset> getAssetList(String application, String adpVersion, String branch) {
        return this.assetMongoDao.selectByApplicationAndAdpVersionAndBranch(application, adpVersion, branch);
    }

    @Override
    public List<Asset> getRefDTDAssetList(String application, String adpVersion, String branch) {
        AssetRelationInfoDto assetRelationInfoDto = AssetRelationInfoDto.create(null, application, adpVersion, branch);
        List<AssetRelation> bindDTDRefRelations = this.getBindDTDRefRelation(assetRelationInfoDto);
        List<String> assetIds = bindDTDRefRelations.stream().map(AssetRelation::getAssetId).collect(Collectors.toList());
        if (assetIds.isEmpty()) {
            return new ArrayList<Asset>();
        }
        return this.getEffectAssets(assetIds);
    }

    @Override
    public Boolean removeRefRelation(List<String> assetIds, String adpVersion, String branch, String application) {
        if (CollectionUtils.isEmpty(assetIds)) {
            return true;
        }
        this.assetRelationMongoDao.deleteByAssetIdsAndVersionAndBranchAndApp(assetIds, adpVersion, branch, application);
        return true;
    }

    @Override
    public List<AssetRelation> getBindDTDRefRelation(AssetRelationInfoDto assetRelationInfoDto) {
        List<AssetRelation> assetRelations = this.assetRelationMongoDao.select(assetRelationInfoDto, AssetDefinition.AssetTypeEnum.DTD);
        return assetRelations;
    }

    @Override
    public Boolean removeReferenceRel(AssetRelationInfoDto assetRelationInfoDto) {
        this.assetRelationMongoDao.delete(assetRelationInfoDto);
        return true;
    }

    @Override
    public Asset getEffectAsset(String assetId) {
        return this.assetMongoDao.selectEffectByAssetId(assetId);
    }

    @Override
    public List<Asset> getEffectAssets(List<String> assetIds) {
        return this.assetMongoDao.selectEffectByAssetIds(assetIds);
    }

    @Override
    public Map<String, Asset> getEffectAssetVersion(List<String> assetIds) {
        HashMap<String, Asset> res = new HashMap<String, Asset>();
        if (CollectionUtils.isEmpty(assetIds)) {
            return res;
        }
        List<Asset> assets = this.assetMongoDao.selectEffectVersionByAssetIds(assetIds);
        for (Asset asset : assets) {
            res.put(asset.getAssetId(), asset);
        }
        return res;
    }

    @Override
    public Asset getHistoryAsset(String assetId, String sourceBranch, String adpVersion) {
        return this.assetMongoDao.selectByAssetIdAndSourceBranchAndAdpVersion(assetId, sourceBranch, adpVersion);
    }

    @Override
    public Boolean availableAsset(AssetInfoDto assetInfoDto) {
        String assetId = this.saveDTDAsset(assetInfoDto);
        this.updateStatus(AssetDefinition.AVAILABLE_STATUS, assetId);
        return true;
    }

    @Override
    public Boolean updateAssetDefinition(AssetOpenReqDto assetOpenReqDto) {
        if (assetOpenReqDto.getCanReference().booleanValue()) {
            Asset asset = this.assetMongoDao.selectEffectByAssetId(assetOpenReqDto.getAssetId());
            Assert.notNull((Object)asset, (String)"\u8be5\u8d44\u4ea7\u6ca1\u6709\u751f\u6548\u7248\u672c\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u5f15\u7528");
        }
        AssetDefinition assetDefinition = this.assetDefinitionMongoDao.selectByAssetId(assetOpenReqDto.getAssetId());
        Assert.notNull((Object)assetDefinition, (String)(assetDefinition.getAssetId() + "\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u8d44\u4ea7"));
        BeanUtils.copyProperties((Object)assetOpenReqDto, (Object)assetDefinition);
        assetDefinition.getPermission().setTenantInfos(assetOpenReqDto.getTenantInfos());
        UserHelper.fillEditInfo((Object)assetDefinition);
        this.assetDefinitionMongoDao.save(assetDefinition);
        try {
            if (AssetDefinition.AVAILABLE_STATUS.equals(assetDefinition.getStatus()) && !assetDefinition.getCopyableItems().isEmpty()) {
                List<Asset> assetBasicInfoList = this.assetMongoDao.selectBasicInfoByObjectId(assetDefinition.getCopyableItems());
                this.updateAssetData(assetBasicInfoList);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("\u540c\u6b65\u53ef\u590d\u5236\u7248\u672c\u5f02\u5e38:" + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("\u540c\u6b65\u53ef\u590d\u5236\u7248\u672c\u5f02\u5e38:" + e.getMessage(), e);
        }
        return true;
    }

    @Override
    public Boolean availableAsset(AssetOpenReqDto assetOpenReqDto) {
        try {
            if (assetOpenReqDto.getCanReference().booleanValue()) {
                Asset asset = this.assetMongoDao.selectEffectByAssetId(assetOpenReqDto.getAssetId());
                Assert.notNull((Object)asset, (String)"\u8be5\u8d44\u4ea7\u6ca1\u6709\u751f\u6548\u7248\u672c\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u5f15\u7528");
            }
            AssetDefinition assetDefinition = this.assetDefinitionMongoDao.selectByAssetId(assetOpenReqDto.getAssetId());
            Assert.notNull((Object)assetDefinition, (String)(assetDefinition.getAssetId() + "\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u8d44\u4ea7"));
            BeanUtils.copyProperties((Object)assetOpenReqDto, (Object)assetDefinition);
            assetDefinition.setStatus(AssetDefinition.AVAILABLE_STATUS);
            UserHelper.fillEditInfo((Object)assetDefinition);
            this.assetDefinitionMongoDao.save(assetDefinition);
            if (!assetOpenReqDto.getCopyableItems().isEmpty()) {
                Map<String, AssetBusinessDataAction> assetBusinessDataActions = this.assetCenterRegisterConfig.getAssetBusinessDataActions();
                if (assetBusinessDataActions.containsKey(assetDefinition.getType())) {
                    List<Asset> assetBasicInfoList = this.assetMongoDao.selectBasicInfoByObjectId(assetOpenReqDto.getCopyableItems());
                    this.updateAssetData(assetBasicInfoList);
                } else {
                    log.warn(assetDefinition.getType() + "\u8d44\u4ea7\uff0c\u6ca1\u6709\u6ce8\u518c\u8d44\u4ea7\u6570\u636e\u6267\u884c\u903b\u8f91");
                }
            }
        }
        catch (Exception e) {
            log.error("availableAsset exception:" + e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            throw new RuntimeException(e.getMessage());
        }
        return true;
    }

    @Override
    public Boolean batchAvailableAsset(AssetBatchOpenReqDto assetBatchOpenReqDto) {
        Asset asset;
        List<String> assetIds = assetBatchOpenReqDto.getAssetIds();
        List<AssetDefinition> assetDefinitions = this.assetDefinitionMongoDao.selectByAssetIds(assetIds);
        if (assetBatchOpenReqDto.getCanReference().booleanValue()) {
            for (AssetDefinition assetDefinition : assetDefinitions) {
                asset = this.assetMongoDao.selectEffectByAssetId(assetDefinition.getAssetId());
                Assert.notNull((Object)asset, (String)(assetDefinition.getAssetId() + "\u8be5\u8d44\u4ea7\u6ca1\u6709\u751f\u6548\u7248\u672c\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u5f15\u7528"));
            }
        }
        Assert.isTrue((!assetDefinitions.isEmpty() ? 1 : 0) != 0, (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u8d44\u4ea7\u5b9a\u4e49\u6570\u636e");
        try {
            for (AssetDefinition assetDefinition : assetDefinitions) {
                BeanUtils.copyProperties((Object)assetBatchOpenReqDto, (Object)assetDefinition);
                assetDefinition.setStatus(AssetDefinition.AVAILABLE_STATUS);
                if (assetDefinition.getCopyableItems().isEmpty() && (asset = this.assetMongoDao.selectLatestVersionByAssetIdAndSourceBranchAndApplication(assetDefinition.getAssetId(), "develop", assetDefinition.getManageContext().getApplication())) != null) {
                    assetDefinition.getCopyableItems().add(asset.getObjectId());
                }
                UserHelper.fillEditInfo((Object)assetDefinition);
                this.assetDefinitionMongoDao.save(assetDefinition);
            }
            if (assetBatchOpenReqDto.getCanCopy().booleanValue()) {
                ArrayList<String> allAssetObjId = new ArrayList<String>();
                for (AssetDefinition assetDefinition : assetDefinitions) {
                    List<String> copyableItems = assetDefinition.getCopyableItems();
                    if (copyableItems.isEmpty()) continue;
                    allAssetObjId.addAll(copyableItems);
                }
                if (!allAssetObjId.isEmpty()) {
                    List<Asset> list = this.assetMongoDao.selectBasicInfoByObjectId(allAssetObjId);
                    Map<String, AssetBusinessDataAction> assetBusinessDataActions = this.assetCenterRegisterConfig.getAssetBusinessDataActions();
                    for (Asset asset2 : list) {
                        if (assetBusinessDataActions.containsKey(asset2.getType())) {
                            this.updateAssetData(list);
                            continue;
                        }
                        log.warn(asset2.getType() + "\u8d44\u4ea7\uff0c\u6ca1\u6709\u6ce8\u518c\u8d44\u4ea7\u6570\u636e\u6267\u884c\u903b\u8f91");
                    }
                }
            }
        }
        catch (Exception e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        return true;
    }

    private void updateAssetData(List<Asset> assetBasicInfoList) throws InterruptedException, ExecutionException {
        ArrayList<CompletableFuture<Boolean>> completableFutures = new ArrayList<CompletableFuture<Boolean>>();
        for (Asset asset : assetBasicInfoList) {
            CompletableFuture<Boolean> future = this.asyncUpdateAssetData(asset);
            completableFutures.add(future);
        }
        CompletableFuture[] array = completableFutures.toArray(new CompletableFuture[0]);
        CompletableFuture.allOf(array);
        ArrayList<String> errorAssetIds = new ArrayList<String>();
        for (int i = 0; i < completableFutures.size(); ++i) {
            if (((Boolean)((CompletableFuture)completableFutures.get(i)).get()).booleanValue()) continue;
            Asset asset = assetBasicInfoList.get(i);
            errorAssetIds.add(asset.getAssetId());
        }
        Assert.isTrue((boolean)errorAssetIds.isEmpty(), (String)(String.join((CharSequence)",", errorAssetIds) + "\u8d44\u4ea7\u540c\u6b65\u5931\u8d25"));
    }

    private CompletableFuture<Boolean> asyncUpdateAssetData(Asset asset) {
        UserPO currentUser = UserHelper.getCurrentUser();
        Map<String, AssetBusinessDataAction> assetBusinessDataActions = this.assetCenterRegisterConfig.getAssetBusinessDataActions();
        return CompletableFuture.supplyAsync(() -> {
            try {
                AssetBusinessDataAction assetBusinessDataAction = (AssetBusinessDataAction)assetBusinessDataActions.get(asset.getType());
                AssetInfoDto assetBusinessDataDto = assetBusinessDataAction.loadBusinessData(AssetInfoDto.create(asset));
                if (assetBusinessDataDto != null) {
                    asset.setContent(assetBusinessDataDto.getContent());
                    asset.setBusinessData(JSONObject.toJSONString((Object)assetBusinessDataDto.getBusinessData()));
                    asset.setEditBy(currentUser.getName());
                    asset.setEditDate(new Date());
                    this.assetMongoDao.save(asset);
                    return true;
                }
                log.warn(String.format("\u8d44\u4ea7objectId:%s,\u8fd4\u56de\u7684\u4e1a\u52a1\u5bf9\u8c61\u4e3anull", asset.getObjectId()));
                return false;
            }
            catch (Exception e) {
                log.error("syncAssetData error:" + e.getMessage(), (Throwable)e);
                return false;
            }
        }, this.assetCenterPool);
    }

    private void updateStatus(Integer status, String assetId) {
        this.assetDefinitionMongoDao.updateStatus(status, UserHelper.getCurrentUser().getName(), assetId);
    }

    @Override
    public Boolean removedAsset(String code, String application) {
        AssetDefinition assetDefinition = this.assetDefinitionMongoDao.selectByApplicationAndCode(code, application);
        this.updateStatus(AssetDefinition.REMOVED_STATUS, assetDefinition.getAssetId());
        return true;
    }

    @Override
    public Boolean removedAsset(String assetId) {
        this.updateStatus(AssetDefinition.REMOVED_STATUS, assetId);
        return true;
    }

    @Override
    public void deleteVersionAsset(AssetInfoDto assetInfoDto) {
        Assert.isTrue((boolean)assetInfoDto.judgeDeleteRequiredFields(), (String)"\u9700\u8981\u8865\u5145\u5fc5\u586b\u5b57\u6bb5");
        List<Asset> assets = this.assetMongoDao.selectByCodeAndApplicationAndSourceBranchAndAdpVersion(assetInfoDto.convertAsset());
        for (Asset asset : assets) {
            this.backupBusinessData(asset);
            this.assetMongoDao.delete(asset);
            this.modifySyncDefinition(asset.getAssetId());
        }
    }

    private void backupBusinessData(Asset asset) {
        if (VersionStatusEnum.RUN_STATE.getCode().equals(asset.getManageContext().getAdpStatus())) {
            Map<String, AssetBusinessDataAction> assetBusinessDataActions = this.assetCenterRegisterConfig.getAssetBusinessDataActions();
            AssetBusinessDataAction assetBusinessDataAction = assetBusinessDataActions.get(asset.getType());
            AssetInfoDto assetBusinessDataDto = assetBusinessDataAction.loadBusinessData(AssetInfoDto.create(asset));
            AssetDefinition assetDefinition = this.assetDefinitionMongoDao.selectByAssetId(asset.getAssetId());
            assetDefinition.setBusinessData(JSONObject.toJSONString((Object)assetBusinessDataDto.getBusinessData()));
            this.assetDefinitionMongoDao.save(assetDefinition);
        }
    }

    @Override
    public void deleteAsset(Asset asset) {
        this.backupBusinessData(asset);
        this.assetMongoDao.delete(asset);
        this.modifySyncDefinition(asset.getAssetId());
    }

    private void modifySyncDefinition(String assetId) {
        AssetDefinition assetDefinition = this.assetDefinitionMongoDao.selectByAssetId(assetId);
        Map<String, Asset> assetAllVersion = this.getAssetAllVersion(assetId);
        if (assetAllVersion.isEmpty()) {
            assetDefinition.setCanReference(false);
            assetDefinition.setCanCopy(false);
            assetDefinition.setStatus(AssetDefinition.REMOVED_STATUS);
        } else {
            boolean hasEffect = false;
            for (Map.Entry<String, Asset> entry : assetAllVersion.entrySet()) {
                Asset value = entry.getValue();
                hasEffect = hasEffect || VersionStatusEnum.RUN_STATE.getCode().equals(value.getManageContext().getAdpStatus());
            }
            if (!CollectionUtils.isEmpty(assetDefinition.getCopyableItems())) {
                Iterator<String> iterator = assetDefinition.getCopyableItems().iterator();
                while (iterator.hasNext()) {
                    String oId = iterator.next();
                    if (assetAllVersion.containsKey(oId)) continue;
                    iterator.remove();
                }
            }
            assetDefinition.setCanReference(assetDefinition.getCanReference() != false && hasEffect);
            if (assetDefinition.getCopyableItems().isEmpty()) {
                assetDefinition.setCanCopy(false);
            }
            if (!assetDefinition.getCanCopy().booleanValue() && !assetDefinition.getCanReference().booleanValue()) {
                assetDefinition.setStatus(AssetDefinition.REMOVED_STATUS);
            }
        }
        UserHelper.fillEditInfo((Object)assetDefinition);
        this.assetDefinitionMongoDao.save(assetDefinition);
    }

    @Override
    public String getAssetDefinitionBusinessData(String code, String application) {
        AssetDefinition assetDefinition = this.assetDefinitionMongoDao.selectByApplicationAndCode(code, application);
        return assetDefinition.getBusinessData();
    }

    @Override
    public AssetPagination<AssetCenterInfoResDto> getAssetCenterList(PageReqCondition<String> pageReqCondition, String type) {
        AssetType assetType;
        JSONObject rowDataPermissionJo;
        List<String> types = type == null ? List.of() : List.of(type);
        PermissionResDto permissionResDto = null;
        if (type != null && (rowDataPermissionJo = (assetType = this.rAssetTypeMongoDao.selectByType(type)).getRowDataPermission()) != null && StringUtils.isNotEmpty((CharSequence)rowDataPermissionJo.getString("url"))) {
            ExecuteConfig rowDataPermission = (ExecuteConfig)JSONObject.parseObject((String)rowDataPermissionJo.toJSONString(), ExecuteConfig.class);
            HttpExecuteConfig httpExecuteConfig = new HttpExecuteConfig();
            httpExecuteConfig.setUrl(rowDataPermission.getUrl());
            if (!StringUtils.isEmpty((CharSequence)rowDataPermission.getMethod())) {
                httpExecuteConfig.setMethod(rowDataPermission.getMethod());
            }
            httpExecuteConfig.setRequestScript(rowDataPermission.getRequestScript());
            httpExecuteConfig.setResponseScript(rowDataPermission.getResponseScript());
            httpExecuteConfig.setHeaders((Map)rowDataPermission.getHeaders());
            try {
                ResultDto resultDto = (ResultDto)this.httpActuator.execute(httpExecuteConfig, new HashMap(), this.variableService.buildContextMap(), ResultDto.class);
                if (resultDto.getCode() != 0) {
                    log.error("\u67e5\u8be2\u5f02\u5e38" + resultDto.getMsg());
                    throw new RuntimeException("\u67e5\u8be2\u5f02\u5e38" + resultDto.getMsg());
                }
                permissionResDto = (PermissionResDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)resultDto.getData())).toJavaObject(PermissionResDto.class);
            }
            catch (Exception e) {
                log.error("\u6267\u884c\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
                AssetPagination<AssetCenterInfoResDto> result = this.buildPageAssetCenterInfo(pageReqCondition, new ArrayList(), 0L, true);
                result.setHasAuth(false);
                return result;
            }
        }
        if (permissionResDto != null && permissionResDto.getDenyAll().booleanValue()) {
            AssetPagination<AssetCenterInfoResDto> result = this.buildPageAssetCenterInfo(pageReqCondition, new ArrayList(), 0L, true);
            return result;
        }
        PermissionConditionResDto rowPermission = permissionResDto == null ? null : permissionResDto.getRowPermission();
        Long count = this.assetDefinitionMongoDao.countPagination(pageReqCondition, CurThreadInfoUtils.getCurTokenTenant().getTenantId(), types, rowPermission);
        List<AssetDefinition> assetDefinitions = this.assetDefinitionMongoDao.selectPagination(pageReqCondition, CurThreadInfoUtils.getCurTokenTenant().getTenantId(), types, rowPermission);
        List<AssetCenterInfoResDto> assetCenterInfoResDtoList = this.convertAssetCenterInfoResDtos(assetDefinitions);
        return this.buildPageAssetCenterInfo(pageReqCondition, assetCenterInfoResDtoList, count, true);
    }

    private List<AssetCenterInfoResDto> convertAssetCenterInfoResDtos(List<AssetDefinition> assetDefinitions) {
        List<String> assetIds = assetDefinitions.stream().map(AssetDefinition::getAssetId).collect(Collectors.toList());
        Map<String, Asset> effectAssetVersionMap = this.getEffectAssetVersion(assetIds);
        Set<String> existAssetIds = this.assetMongoDao.selectExistAssetId(assetIds);
        Map<String, Asset> lastVersionAssetVersionMap = this.getLastVersionAssetVersion(assetIds);
        List<AssetCenterInfoResDto> assetCenterInfoResDtoList = assetDefinitions.stream().map(a -> {
            AssetCenterInfoResDto assetCenterInfoResDto = AssetCenterInfoResDto.create(a);
            Asset effecAsset = (Asset)effectAssetVersionMap.get(assetCenterInfoResDto.getAssetId());
            if (effecAsset != null) {
                assetCenterInfoResDto.setEffectAdpVersion(effecAsset.getManageContext().getAdpVersion());
                assetCenterInfoResDto.setEffectAdpRemarkNumber(effecAsset.getShowFields().getAdpRemarkNumber());
            }
            assetCenterInfoResDto.setLatestVersionAsset((Asset)lastVersionAssetVersionMap.get(assetCenterInfoResDto.getAssetId()));
            assetCenterInfoResDto.setHasResult(existAssetIds.contains(assetCenterInfoResDto.getAssetId()));
            return assetCenterInfoResDto;
        }).collect(Collectors.toList());
        return assetCenterInfoResDtoList;
    }

    private Map<String, Asset> getLastVersionAssetVersion(List<String> assetIds) {
        HashMap<String, Asset> res = new HashMap<String, Asset>();
        List<Asset> lastVersionAssetList = this.assetMongoDao.selectVersionInfo(assetIds);
        for (Asset asset : lastVersionAssetList) {
            if (res.containsKey(asset.getAssetId())) continue;
            res.put(asset.getAssetId(), asset);
        }
        return res;
    }

    @Override
    public AssetDetailResDto getAsset(String assetId) {
        AssetDefinition assetDefinition = this.assetDefinitionMongoDao.selectByAssetId(assetId);
        AssetDetailResDto assetDetailResDto = AssetDetailResDto.create(assetDefinition);
        return assetDetailResDto;
    }

    @Override
    public AssetDetailResDto assetDetailV2(AssetReqDto assetReqDto) {
        AssetDefinition assetDefinition = null;
        assetDefinition = !StringUtils.isEmpty((CharSequence)assetReqDto.getAssetId()) ? this.assetDefinitionMongoDao.selectByAssetId(assetReqDto.getAssetId()) : this.assetDefinitionMongoDao.selectByCodeAndType(assetReqDto.getCode(), assetReqDto.getType());
        if (assetDefinition == null) {
            return null;
        }
        return AssetDetailResDto.create(assetDefinition);
    }

    @Override
    public List<AssetDetailResDto> getAssetMenuInfo(Asset.ManageContext manageContext) {
        List<Asset> assetList = this.assetMongoDao.selectByManageContext(manageContext);
        HashMap<String, Asset> map = new HashMap<String, Asset>();
        for (Asset asset : assetList) {
            if (map.containsKey(asset.getAssetId())) continue;
            map.put(asset.getAssetId(), asset);
        }
        Collection values = map.values();
        return values.stream().map(v -> AssetDetailResDto.create(v)).collect(Collectors.toList());
    }

    @Override
    public List<AssetRelationAppInfoResDto> getAssetRefRelation(String assetId, Boolean isAssetCenter) {
        ArrayList<AssetRelationAppInfoResDto> res = new ArrayList<AssetRelationAppInfoResDto>();
        List<AssetRelation> relations = this.assetRelationMongoDao.selectByAssetIdAndType(assetId, AssetRelation.BelongTypeEnum.REF_TYPE.getType());
        if (!relations.isEmpty()) {
            Map<String, List<AssetRelation>> relationMap = relations.stream().collect(Collectors.groupingBy(a -> a.getSource().getApplication()));
            List applications = isAssetCenter != null && isAssetCenter != false ? this.applicationMongoDao.selectByCodesAndTenantId(relationMap.keySet(), CurThreadInfoUtils.getCurTokenTenant().getTenantId()) : this.applicationMongoDao.selectByCodes(relationMap.keySet());
            for (Map.Entry<String, List<AssetRelation>> entry : relationMap.entrySet()) {
                AssetRelation assetRelation = entry.getValue().get(0);
                AssetRelationAppInfoResDto assetRelationAppInfoResDto = new AssetRelationAppInfoResDto();
                assetRelationAppInfoResDto.setAssetId(assetRelation.getAssetId());
                for (Application application : applications) {
                    if (!application.getCode().equals(assetRelation.getSource().getApplication())) continue;
                    assetRelationAppInfoResDto.setName(application.getName());
                    assetRelationAppInfoResDto.setApplication(application.getCode());
                    assetRelationAppInfoResDto.setTenantId(application.getTenantId());
                    assetRelationAppInfoResDto.setLang(application.getLang());
                    break;
                }
                res.add(assetRelationAppInfoResDto);
            }
        }
        return res;
    }

    @Override
    public Integer assetErrorCount(String appCode) {
        List<String> assetIdsRelation = this.assetRelationMongoDao.selectAssetIdByAppCode(appCode, AssetDefinition.AssetTypeEnum.DTD.getCode());
        List<String> assetIds = this.assetDefinitionMongoDao.selectAssetIdAvailableStatusByApplication(appCode, AssetDefinition.AssetTypeEnum.DTD.getCode());
        Long count = this.assetMongoDao.selectEffectCount(assetIdsRelation);
        Set<String> existAssetIds = this.assetMongoDao.selectExistAssetId(assetIds);
        return assetIdsRelation.size() - count.intValue() + (assetIds.size() - existAssetIds.size());
    }

    @Override
    public Pagination<AssetCenterInfoResDto> appAssetList(PageReqCondition<String> pageReqCondition, List<String> appCodes, List<String> types) {
        Long count = this.assetDefinitionMongoDao.countApplicationPagination(pageReqCondition, appCodes, types);
        List<AssetDefinition> assetDefinitions = this.assetDefinitionMongoDao.selectApplicationPagination(pageReqCondition, appCodes, types);
        List<AssetCenterInfoResDto> assetCenterInfoResDtoList = this.convertAssetCenterInfoResDtos(assetDefinitions);
        return this.buildPageAssetCenterInfo(pageReqCondition, assetCenterInfoResDtoList, count, false);
    }

    @Override
    public AssetPagination<AssetDetailResDto> designerAssetList(PageReqCondition<DesignerAssetListReqDto> pageReqCondition) {
        Long count = this.assetMongoDao.countDesignerAssetPagination(pageReqCondition);
        List<Asset> assets = this.assetMongoDao.selectDesignerAssetPagination(pageReqCondition);
        List res = assets.stream().map(AssetDetailResDto::create).collect(Collectors.toList());
        return this.buildPageAssetCenterInfo(pageReqCondition, res, count, false);
    }

    @Override
    public List<DepAssetResDto> getDepAssets(String objId) {
        Asset asset = this.assetMongoDao.selectByObjectId(objId);
        Assert.notNull((Object)asset, (String)"\u6ca1\u6709\u8be5\u8d44\u4ea7\u4fe1\u606f");
        List<AssetDepInfo> assetDepInfos = this.assetDepInfoMongoDao.selectBySourceId(asset.getObjectId());
        Map<String, AssetDepInfo> assetDepInfoMap = assetDepInfos.stream().collect(Collectors.toMap(AssetDepInfo::getTargetAssetId, a -> a));
        ArrayList<DepAssetResDto> res = new ArrayList<DepAssetResDto>();
        if (!assetDepInfos.isEmpty()) {
            List<AssetDefinition> assetDefinitions = this.assetDefinitionMongoDao.selectByAssetIds(assetDepInfoMap.keySet());
            if (assetDefinitions.isEmpty()) {
                return res;
            }
            Map<String, AssetDefinition> assetDefinitionMap = assetDefinitions.stream().collect(Collectors.toMap(AssetDefinition::getAssetId, a -> a));
            for (Map.Entry<String, AssetDepInfo> entry : assetDepInfoMap.entrySet()) {
                String key = entry.getKey();
                if (!assetDefinitionMap.containsKey(key)) continue;
                res.add(DepAssetResDto.create(entry.getValue(), assetDefinitionMap.get(entry.getKey())));
            }
        }
        return res;
    }

    @Override
    public void assetInit(String appCode, String type) {
        if ("ALL".equalsIgnoreCase(type) || AssetDefinition.AssetTypeEnum.DTD.getCode().equals(type)) {
            this.assetInit.dtdAssetInit(appCode);
        }
        Application application = this.applicationMongoDao.getApplication(appCode);
        UserHelper.fillEditInfo((Object)application);
        if ("ALL".equalsIgnoreCase(type)) {
            application.getAssetInitFlag().put(AssetDefinition.AssetTypeEnum.DTD.getCode(), true);
            application.getAssetInitFlag().put(type, true);
        } else {
            application.getAssetInitFlag().put(type, true);
        }
        this.applicationMongoDao.save(application);
    }

    @Override
    public Pagination<DependentAssetResDto> getDependAssetInfoList(PageReqCondition<String> pageReqCondition, String appCode, String type) {
        Long count = this.assetRelationMongoDao.selectCountPagination(pageReqCondition, appCode, type);
        List<AssetRelation> relations = this.assetRelationMongoDao.selectPagination(pageReqCondition, appCode, type);
        Set<String> assetIds = relations.stream().map(AssetRelation::getAssetId).collect(Collectors.toSet());
        List<Asset> assets = this.assetMongoDao.selectEffectByAssetIds(assetIds);
        List<AssetDefinition> assetDefinitions = this.assetDefinitionMongoDao.selectByAssetIds(assetIds);
        ArrayList<DependentAssetResDto> res = new ArrayList<DependentAssetResDto>();
        for (AssetRelation re : relations) {
            AssetDefinition existAssetDefinition;
            DependentAssetResDto dependentAssetResDto = new DependentAssetResDto();
            dependentAssetResDto.setObjectId(re.getObjectId());
            dependentAssetResDto.setAssetId(re.getAssetId());
            Asset existAsset = assets.stream().filter(a -> a.getAssetId().equals(re.getAssetId())).findFirst().orElse(null);
            if (existAsset != null) {
                dependentAssetResDto.setReferenceInvalid(false);
                dependentAssetResDto.setAdpVersion(existAsset.getManageContext().getAdpVersion());
                dependentAssetResDto.setAdpRemarkNumber(existAsset.getShowFields().getAdpRemarkNumber());
            }
            if ((existAssetDefinition = (AssetDefinition)assetDefinitions.stream().filter(a -> a.getAssetId().equals(re.getAssetId())).findFirst().orElse(null)) != null) {
                dependentAssetResDto.setAssetName(existAssetDefinition.getAssetName());
                dependentAssetResDto.setAssetDesc(existAssetDefinition.getAssetDesc());
                dependentAssetResDto.setPublisher(existAssetDefinition.getPublisher());
                dependentAssetResDto.setPublisherName(existAssetDefinition.getPublisherName());
                dependentAssetResDto.setApplication(existAssetDefinition.getManageContext().getApplication());
                dependentAssetResDto.setType(existAssetDefinition.getType());
                dependentAssetResDto.setCode(existAssetDefinition.getCode());
            }
            dependentAssetResDto.setAssetRelation(re);
            res.add(dependentAssetResDto);
        }
        return Pagination.buildPagination(pageReqCondition, res, (Long)count);
    }

    @Override
    public List<AssetInfoResDto> assetVersionList(String assetId) {
        List<Asset> assets = this.assetMongoDao.selectByAssetId(assetId);
        return assets.stream().map(a -> AssetInfoResDto.create(a)).collect(Collectors.toList());
    }

    @Override
    public Pagination<AssetDetailResDto> getSameTenantDtdAsset(PageReqCondition<String> pageReqCondition) {
        Long count = this.assetDefinitionMongoDao.countSameTenantDtdAsset(pageReqCondition, CurThreadInfoUtils.getCurTokenTenant().getTenantId(), AssetDefinition.AssetTypeEnum.DTD.getCode());
        List<AssetDefinition> assetDefinitions = this.assetDefinitionMongoDao.selectSameTenantDtdAsset(pageReqCondition, CurThreadInfoUtils.getCurTokenTenant().getTenantId(), AssetDefinition.AssetTypeEnum.DTD.getCode());
        List assetDetailResDtoList = assetDefinitions.stream().map(a -> AssetDetailResDto.create(a)).collect(Collectors.toList());
        return Pagination.buildPagination(pageReqCondition, assetDetailResDtoList, (Long)count);
    }

    @Override
    public Pagination<AssetDetailResDto> getPlatformDtdAsset(PageReqCondition<String> pageReqCondition) {
        Long count = this.assetDefinitionMongoDao.countPlatformDtdAsset(pageReqCondition, CurThreadInfoUtils.getCurTokenTenant().getTenantId(), AssetDefinition.AssetTypeEnum.DTD.getCode());
        List<AssetDefinition> assetDefinitions = this.assetDefinitionMongoDao.selectPlatformDtdAsset(pageReqCondition, CurThreadInfoUtils.getCurTokenTenant().getTenantId(), AssetDefinition.AssetTypeEnum.DTD.getCode());
        List assetDetailResDtoList = assetDefinitions.stream().map(a -> AssetDetailResDto.create(a)).collect(Collectors.toList());
        return Pagination.buildPagination(pageReqCondition, assetDetailResDtoList, (Long)count);
    }

    @Override
    public Boolean removedAssetOpenTenant(String assetId) {
        AssetDefinition assetDefinition = this.assetDefinitionMongoDao.selectByAssetId(assetId);
        if ("all".equals(assetDefinition.getOpenRange())) {
            throw new RuntimeException("\u8be5\u8d44\u4ea7\u5f00\u653e\u8303\u56f4\u4e3a\u5e73\u53f0\u7ea7\uff0c\u4e0d\u80fd\u76f4\u63a5\u4e0b\u67b6");
        }
        if ("curTenant".equals(assetDefinition.getOpenRange())) {
            assetDefinition.setStatus(AssetDefinition.REMOVED_STATUS);
        }
        if ("tenant".equals(assetDefinition.getOpenRange())) {
            List<com.digiwin.athena.domain.pagedesign.TenantInfo> tenantInfos = assetDefinition.getPermission().getTenantInfos();
            String tenantId = CurThreadInfoUtils.getCurTokenTenant().getTenantId();
            Iterator<com.digiwin.athena.domain.pagedesign.TenantInfo> iterator = tenantInfos.iterator();
            while (iterator.hasNext()) {
                com.digiwin.athena.domain.pagedesign.TenantInfo tenantInfo = iterator.next();
                if (!tenantId.equals(tenantInfo.getTenantId())) continue;
                iterator.remove();
            }
            if (tenantInfos.isEmpty()) {
                assetDefinition.setStatus(AssetDefinition.REMOVED_STATUS);
            }
        }
        UserHelper.fillEditInfo((Object)assetDefinition);
        this.assetDefinitionMongoDao.save(assetDefinition);
        return true;
    }

    private <T extends AssetCenterInfoResDto> AssetPagination<T> buildPageAssetCenterInfo(PageReqCondition<?> pageReqCondition, List<T> assetCenterInfoResDtoList, Long count, Boolean isAssetCenter) {
        for (AssetCenterInfoResDto assetCenterInfoResDto : assetCenterInfoResDtoList) {
            Collection<String> appCodes = this.assetRelationMongoDao.selectRefAppAppByAssetId(assetCenterInfoResDto.getAssetId());
            Integer refCount = appCodes.size();
            if (!appCodes.isEmpty() && isAssetCenter.booleanValue()) {
                refCount = this.applicationMongoDao.selectCountByCodesAndTenantId(appCodes, CurThreadInfoUtils.getCurTokenTenant().getTenantId()).intValue();
            }
            assetCenterInfoResDto.setCurReferenceCount(refCount);
        }
        return AssetPagination.buildPagination(pageReqCondition, assetCenterInfoResDtoList, count);
    }

    @Override
    public void copyAppRef(String application, String fromBranch, String toBranch) {
        List<Asset> fromAssetList;
        List<AssetRelation> relations = this.assetRelationMongoDao.selectByApplicationAndBranch(application, fromBranch);
        this.assetRelationMongoDao.deleteByApplicationAndBranch(application, toBranch);
        if (!relations.isEmpty()) {
            for (AssetRelation relation : relations) {
                relation.setObjectId(null);
                relation.getSource().setUserBranch(toBranch);
            }
            this.assetRelationMongoDao.insertAll(relations);
        }
        if (!(fromAssetList = this.assetMongoDao.selectByApplicationAndBranch(application, fromBranch)).isEmpty()) {
            for (Asset asset : fromAssetList) {
                asset.setObjectId(null);
                asset.getManageContext().setBranch(toBranch);
                if ("develop".equals(toBranch)) continue;
                asset.getManageContext().setAdpStatus(VersionStatusEnum.DESIGN_STATE.getCode());
            }
            this.assetMongoDao.deleteByApplicationAndBranch(application, toBranch);
            this.assetMongoDao.insertAll(fromAssetList);
        }
    }

    @Override
    public void copyRelationMultipleVersions(String oldVersion, String newVersion, String branch, String appCode) {
        List<AssetRelation> assetRelations = this.assetRelationMongoDao.selectByUserBranchAndAdpVersionAndApp(oldVersion, branch, appCode);
        if (!assetRelations.isEmpty()) {
            for (AssetRelation assetRelation : assetRelations) {
                assetRelation.setObjectId(null);
                assetRelation.getSource().setAdpVersion(newVersion);
            }
            this.assetRelationMongoDao.insertAll(assetRelations);
        }
    }

    @Override
    public void removeRelationMultipleVersions(String version, String branch, String appCode) {
        this.assetRelationMongoDao.deleteByAdpVersionAndBranchAndApplication(version, branch, appCode);
    }

    @Override
    public Boolean batchSyncAsset(List<String> assetIds) {
        List<AssetDefinition> assetDefinitions = this.assetDefinitionMongoDao.selectByAssetIdsAndStatus(assetIds, AssetDefinition.AVAILABLE_STATUS);
        try {
            for (AssetDefinition assetDefinition : assetDefinitions) {
                if (assetDefinition.getCopyableItems().isEmpty()) continue;
                List<Asset> assetBasicInfoList = this.assetMongoDao.selectBasicInfoByObjectId(assetDefinition.getCopyableItems());
                this.updateAssetData(assetBasicInfoList);
            }
        }
        catch (Exception e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("\u540c\u6b65\u53ef\u590d\u5236\u7248\u672c\u5f02\u5e38", e);
        }
        return true;
    }

    @Override
    public AssetDefinition findAssetDefinition(String assetId) {
        return this.assetDefinitionMongoDao.selectByAssetId(assetId);
    }

    @Override
    public void save(AssetDefinition assetDefinition) {
        this.assetDefinitionMongoDao.save(assetDefinition);
    }

    @Override
    public void draftDtdAllVersion(String application) {
        this.assetMongoDao.updateDraftByApplicationAndType(application, AssetDefinition.AssetTypeEnum.DTD);
    }

    @Override
    public Pagination<AssetCenterInfoResDto> appUseAssetList(PageReqCondition<UseAssetListReqDto> pageReqCondition) {
        Long count = this.assetDefinitionMongoDao.countAppUseAssetList(pageReqCondition);
        List<AssetDefinition> assetDefinitions = this.assetDefinitionMongoDao.selectAppUseAssetList(pageReqCondition);
        List<AssetCenterInfoResDto> assetCenterInfoResDtoList = this.convertAssetCenterInfoResDtos(assetDefinitions);
        Pagination res = Pagination.buildPagination(pageReqCondition, assetCenterInfoResDtoList, (Long)count);
        return res;
    }

    @Override
    public void unbindingRelationship(String taskCodes, String type, String appCode) {
        List<String> taskCodeArr = Arrays.asList(taskCodes.split(","));
        List<AssetDefinition> assetDefinitions = this.assetDefinitionMongoDao.selectByCodesAndType(taskCodeArr, type);
        if (taskCodeArr.size() > assetDefinitions.size()) {
            Set existsCodes = assetDefinitions.stream().map(AssetDefinition::getCode).collect(Collectors.toSet());
            for (String code : taskCodeArr) {
                if (existsCodes.contains(code)) continue;
                throw new RuntimeException(code + "\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8d44\u4ea7\u4fe1\u606f");
            }
        }
        for (AssetDefinition assetDefinition : assetDefinitions) {
            AssetRelation assetRelation = this.assetRelationMongoDao.selectByAssetIdAndAdpVersionAndUserBranchAndApplication(assetDefinition.getAssetId(), CurThreadInfoUtils.getAdpVersion(), CurThreadInfoUtils.getBranchKey(), appCode);
            Assert.notNull((Object)assetRelation, (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u5f15\u7528\u6b64\u8d44\u4ea7\u7684\u5173\u7cfb");
            this.assetRelationMongoDao.deleteByObjectId(assetRelation.getObjectId());
        }
    }

    @Override
    public List<AssetInfoResDto> assetCanCopyVersionList(String assetId) {
        AssetDefinition assetDefinition = this.assetDefinitionMongoDao.selectByAssetId(assetId);
        Assert.notNull((Object)assetDefinition, (String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u8d44\u4ea7");
        List<String> copyableItems = assetDefinition.getCopyableItems();
        if (!CollectionUtils.isEmpty(copyableItems)) {
            List<Asset> assets = this.assetMongoDao.selectByIds(copyableItems);
            return assets.stream().map(a -> AssetInfoResDto.create(a)).collect(Collectors.toList());
        }
        return new ArrayList<AssetInfoResDto>();
    }

    @Override
    public AssetCenterInfoResDto getAssetDefinitionInfo(String code, String type) {
        AssetDefinition assetDefinition = this.assetDefinitionMongoDao.selectByCodeAndType(code, type);
        Assert.notNull((Object)assetDefinition, (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8d44\u4ea7");
        AssetCenterInfoResDto res = AssetCenterInfoResDto.create(assetDefinition);
        Application application = this.applicationMongoDao.selectByCode(res.getApplication());
        Assert.notNull((Object)application, (String)(res.getApplication() + "\u5e94\u7528\u4e0d\u5b58\u5728"));
        res.setApplicationName(application.getName());
        res.getLang().put("applicationName", (MultiLanguageDTO)application.getLang().get("name"));
        Map<String, Asset> effectAssetVersionMap = this.getEffectAssetVersion(Arrays.asList(assetDefinition.getAssetId()));
        Asset asset = effectAssetVersionMap.get(res.getAssetId());
        if (asset != null) {
            res.setEffectAdpVersion(asset.getManageContext().getAdpVersion());
        }
        return res;
    }

    @Override
    public Map<String, Asset> getAssetAllVersion(String assetId) {
        List<Asset> assets = this.assetMongoDao.selectBasicInfoByAssetId(assetId);
        HashMap<String, Asset> res = new HashMap<String, Asset>();
        for (Asset asset : assets) {
            res.put(asset.getObjectId(), asset);
        }
        return res;
    }

    @Override
    public AssetDetailResDto saveAsset(CreateAssetReqDto createAssetReqDto, TenantInfo tenantInfo) {
        AssetType assetType = this.rAssetTypeMongoDao.selectByType(createAssetReqDto.getType());
        Assert.notNull((Object)assetType, (String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5df2\u53d1\u5e03\u6570\u636e");
        Asset.ManageContext manageContext = createAssetReqDto.getManageContext();
        if (StringUtils.isEmpty((CharSequence)manageContext.getDataId())) {
            manageContext.setDataId(createAssetReqDto.getCode());
        }
        AssetDefinition oldAssetDefinition = null;
        if (StringUtils.isEmpty((CharSequence)createAssetReqDto.getAssetId())) {
            if (!StringUtils.isEmpty((CharSequence)createAssetReqDto.getCode())) {
                oldAssetDefinition = this.assetDefinitionMongoDao.selectByCodeAndType(createAssetReqDto.getCode(), createAssetReqDto.getType());
            }
        } else {
            oldAssetDefinition = this.assetDefinitionMongoDao.selectByAssetId(createAssetReqDto.getAssetId());
            Assert.notNull((Object)oldAssetDefinition, (String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8d44\u4ea7\u5b9e\u4f8b");
        }
        if (oldAssetDefinition != null) {
            oldAssetDefinition.setAssetName(createAssetReqDto.getAssetName());
            oldAssetDefinition.setAssetDesc(createAssetReqDto.getAssetDesc());
            oldAssetDefinition.setLang(createAssetReqDto.getLang());
            oldAssetDefinition.setBusinessData(createAssetReqDto.getBusinessData());
            oldAssetDefinition.setManageContext(createAssetReqDto.getManageContext());
            UserHelper.fillEditInfo((Object)oldAssetDefinition);
            this.assetDefinitionMongoDao.save(oldAssetDefinition);
            Asset asset = this.assetMongoDao.selectByAssetIdAndMCDataId(oldAssetDefinition.getAssetId(), createAssetReqDto.getManageContext());
            if (asset == null) {
                asset = createAssetReqDto.convertAsset();
                asset.setAssetId(createAssetReqDto.getAssetId());
                UserHelper.fillCreateInfo((Object)asset);
                UserHelper.fillEditInfo((Object)asset);
                this.assetMongoDao.insert(asset);
            } else {
                asset.setDepResolveError(null);
                asset.setAssetName(createAssetReqDto.getAssetName());
                asset.setBusinessData(createAssetReqDto.getBusinessData());
                asset.setLang(createAssetReqDto.getLang());
                UserHelper.fillEditInfo((Object)asset);
                this.assetMongoDao.save(asset);
            }
            this.resolveDepInfo(asset, assetType, createAssetReqDto.getAssetDepInfos());
            AssetDetailResDto assetDetailResDto = AssetDetailResDto.create(oldAssetDefinition);
            assetDetailResDto.setManageContext(asset.getManageContext());
            assetDetailResDto.setShowFields(asset.getShowFields());
            assetDetailResDto.setAssetObjectId(asset.getObjectId());
            return assetDetailResDto;
        }
        AssetDefinition assetDefinition = createAssetReqDto.convertAssetDefinition();
        String code = StringUtils.isEmpty((CharSequence)assetDefinition.getCode()) ? IdUtil.fastSimpleUUID() : assetDefinition.getCode();
        String assetId = this.buildGeneratorCodeUtil.createAssetId(code, createAssetReqDto.getType());
        assetDefinition.setAssetId(assetId);
        assetDefinition.setCanReference(assetType.getCanReference());
        assetDefinition.setCanCopy(assetType.getCanCopy());
        assetDefinition.setStatus(AssetDefinition.AVAILABLE_STATUS);
        assetDefinition.getManageContext().putAll(createAssetReqDto.getManageContext());
        TenantInfo curTokenTenant = tenantInfo != null ? tenantInfo : CurThreadInfoUtils.getCurTokenTenant();
        assetDefinition.setAdpTenantId(curTokenTenant.getTenantId());
        assetDefinition.setPublisherName(curTokenTenant.getTenantName());
        assetDefinition.setPublisher(curTokenTenant.getTenantId());
        UserHelper.fillCreateInfo((Object)assetDefinition);
        UserHelper.fillEditInfo((Object)assetDefinition);
        this.assetDefinitionMongoDao.insert(assetDefinition);
        Asset asset = createAssetReqDto.convertAsset();
        asset.setAssetId(assetId);
        UserHelper.fillCreateInfo((Object)asset);
        UserHelper.fillEditInfo((Object)asset);
        this.assetMongoDao.insert(asset);
        this.resolveDepInfo(asset, assetType, createAssetReqDto.getAssetDepInfos());
        AssetDetailResDto assetDetailResDto = AssetDetailResDto.create(assetDefinition);
        assetDetailResDto.setManageContext(asset.getManageContext());
        assetDetailResDto.setShowFields(asset.getShowFields());
        assetDetailResDto.setAssetObjectId(asset.getObjectId());
        return assetDetailResDto;
    }

    private void resolveDepInfo(Asset asset, AssetType assetType, List<AssetDepInfo> assetDepInfos) {
        try {
            List<JSONObject> dependencyRule = assetType.getDependencyRule();
            if (CollectionUtils.isEmpty(dependencyRule) && CollectionUtils.isEmpty(assetDepInfos)) {
                this.assetDepInfoMongoDao.deleteBySourceId(asset.getObjectId());
            }
            if (CollectionUtils.isEmpty(assetDepInfos)) {
                assetDepInfos = new ArrayList<AssetDepInfo>();
            }
            if (!CollectionUtils.isEmpty(dependencyRule)) {
                for (JSONObject jsonObject : dependencyRule) {
                    DependencyRule dependency = (DependencyRule)JSONObject.parseObject((String)jsonObject.toJSONString(), DependencyRule.class);
                    if (!dependency.getType().equals("script")) continue;
                    Object depInfo = JSUtil.evalDependencyRule((String)dependency.getScript(), (String)JSONObject.toJSONString((Object)asset), Map.class);
                    List allAnalysisDepInfo = new ArrayList<AssetDepInfo>();
                    if (depInfo instanceof Collection) {
                        allAnalysisDepInfo = JSONObject.parseArray((String)JSONObject.toJSONString((Object)depInfo), AssetDepInfo.class);
                    } else {
                        allAnalysisDepInfo.add((AssetDepInfo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)depInfo), AssetDepInfo.class));
                    }
                    for (AssetDepInfo assetDepInfo : allAnalysisDepInfo) {
                        Asset targetAsset = this.assetMongoDao.selectByCodeAndTypeAndMCDataId(assetDepInfo.getTargetType(), assetDepInfo.getTargetCode(), assetDepInfo.getTargetManageContext());
                        if (targetAsset == null) continue;
                        assetDepInfo.setTargetAssetId(targetAsset.getAssetId());
                        assetDepInfo.setSourceId(asset.getObjectId());
                        assetDepInfos.add(assetDepInfo);
                    }
                }
            }
            Map<String, List<AssetDepInfo>> depInfoMap = assetDepInfos.stream().collect(Collectors.groupingBy(a -> a.getTargetType() + a.getTargetCode() + a.getTargetAssetId()));
            if (!assetDepInfos.isEmpty()) {
                List<AssetDepInfo> needInsertAssetDepInfos;
                List<AssetDepInfo> oldDepInfos = this.assetDepInfoMongoDao.selectBySourceId(asset.getObjectId());
                Map<String, List<AssetDepInfo>> oldDepInfoMap = oldDepInfos.stream().collect(Collectors.groupingBy(a -> a.getTargetType() + a.getTargetCode() + a.getTargetAssetId()));
                List<AssetDepInfo> needDeleteDepInfo = oldDepInfos.stream().filter(o -> {
                    String key = o.getTargetType() + o.getTargetCode() + o.getTargetAssetId();
                    if (depInfoMap.containsKey(key)) {
                        List newAssetDepInfos = (List)depInfoMap.get(key);
                        for (AssetDepInfo newAssetDepInfo : newAssetDepInfos) {
                            if (!newAssetDepInfo.getTargetManageContext().equals((Object)o.getTargetManageContext())) continue;
                            return false;
                        }
                    }
                    return true;
                }).collect(Collectors.toList());
                if (!needDeleteDepInfo.isEmpty()) {
                    needDeleteDepInfo.forEach(n -> this.assetDepInfoMongoDao.delete((AssetDepInfo)n));
                }
                if (!(needInsertAssetDepInfos = assetDepInfos.stream().filter(a -> {
                    String key = a.getTargetType() + a.getTargetCode() + a.getTargetAssetId();
                    if (oldDepInfoMap.containsKey(key)) {
                        List oldAssetDepInfos = (List)oldDepInfoMap.get(key);
                        for (AssetDepInfo oldAssetDepInfo : oldAssetDepInfos) {
                            if (!oldAssetDepInfo.getTargetManageContext().equals((Object)a.getTargetManageContext())) continue;
                            return false;
                        }
                    }
                    return true;
                }).collect(Collectors.toList())).isEmpty()) {
                    this.assetDepInfoMongoDao.insert(needInsertAssetDepInfos);
                }
            } else {
                this.assetDepInfoMongoDao.deleteBySourceId(asset.getObjectId());
            }
        }
        catch (Exception e) {
            asset.setDepResolveError(e.getMessage());
            this.assetMongoDao.save(asset);
            throw new RuntimeException("\u8d44\u4ea7\u89e3\u6790\u4f9d\u8d56\u5f02\u5e38");
        }
    }

    @Override
    public void deleteAsset(AssetReqDto deleteAssetReqDto) {
        AssetDefinition assetDefinition = null;
        assetDefinition = !StringUtils.isEmpty((CharSequence)deleteAssetReqDto.getAssetId()) ? this.assetDefinitionMongoDao.selectByAssetId(deleteAssetReqDto.getAssetId()) : this.assetDefinitionMongoDao.selectByCodeAndType(deleteAssetReqDto.getCode(), deleteAssetReqDto.getType());
        if (assetDefinition == null) {
            return;
        }
        AssetType assetType = this.rAssetTypeMongoDao.selectByType(assetDefinition.getType());
        List deleteApi = List.of(assetType.getApiList()).stream().filter(l -> !CollectionUtils.isEmpty((Collection)l)).flatMap(Collection::stream).filter(a -> "delete".equals(a.getKey())).map(a -> a.getExecuteConfig()).collect(Collectors.toList());
        Assert.isTrue((!CollectionUtils.isEmpty(deleteApi) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u914d\u7f6e\u5220\u9664\u63a5\u53e3");
        List<Asset> assets = this.assetMongoDao.selectByAssetIdAndManageContext(assetDefinition.getAssetId(), deleteAssetReqDto.getManageContext());
        if (!assets.isEmpty()) {
            ObjectMapper mapper = new ObjectMapper();
            Map<String, Object> contextMap = this.variableService.buildContextMap();
            ThirdPartyAssetReqDto thirdPartyAssetReqDto = new ThirdPartyAssetReqDto();
            thirdPartyAssetReqDto.setApplication(assetDefinition.getManageContext().getApplication());
            thirdPartyAssetReqDto.setBranch(CurThreadInfoUtils.getBranchKey());
            for (Asset asset : assets) {
                for (ExecuteConfig executeConfig : deleteApi) {
                    HttpExecuteConfig httpExecuteConfig = executeConfig.createHttpExecuteConfig();
                    httpExecuteConfig.setUrl(executeConfig.getUrl());
                    if (!StringUtils.isEmpty((CharSequence)executeConfig.getMethod())) {
                        httpExecuteConfig.setMethod(executeConfig.getMethod());
                    }
                    httpExecuteConfig.setRequestScript(executeConfig.getRequestScript());
                    httpExecuteConfig.setResponseScript(executeConfig.getResponseScript());
                    httpExecuteConfig.setHeaders((Map)executeConfig.getHeaders());
                    thirdPartyAssetReqDto.setAsset(asset);
                    Map requestParams = (Map)mapper.convertValue((Object)thirdPartyAssetReqDto, (TypeReference)new TypeReference<Map<String, Object>>(){});
                    ResultDto res = (ResultDto)this.httpActuator.execute(httpExecuteConfig, (Object)requestParams, contextMap, ResultDto.class);
                    if (res.getCode().equals(0)) continue;
                    log.error("\u5220\u9664\u5f02\u5e38" + res.getMsg() + JSONObject.toJSONString((Object)asset));
                    throw new RuntimeException("\u5220\u9664\u5f02\u5e38" + res.getMsg());
                }
            }
        }
    }

    @Override
    public void deleteAsset(List<AssetReqDto> deleteAssetReqDtos) {
        for (AssetReqDto deleteAssetReqDto : deleteAssetReqDtos) {
            Set<String> existAssetId;
            AssetDefinition assetDefinition = null;
            assetDefinition = !StringUtils.isEmpty((CharSequence)deleteAssetReqDto.getAssetId()) ? this.assetDefinitionMongoDao.selectByAssetId(deleteAssetReqDto.getAssetId()) : this.assetDefinitionMongoDao.selectByCodeAndType(deleteAssetReqDto.getCode(), deleteAssetReqDto.getType());
            if (assetDefinition == null) continue;
            Asset.ManageContext manageContext = deleteAssetReqDto.getManageContext();
            Asset asset = this.assetMongoDao.selectByCodeAndTypeAndMCDataId(deleteAssetReqDto.getType(), deleteAssetReqDto.getCode(), JSONObject.parseObject((String)JSONObject.toJSONString((Object)manageContext)));
            if (asset != null) {
                this.assetDepInfoMongoDao.deleteBySourceId(asset.getObjectId());
                this.assetMongoDao.delete(asset);
            }
            if (!(existAssetId = this.assetMongoDao.selectExistAssetId(List.of(assetDefinition.getAssetId()))).isEmpty()) continue;
            this.assetDefinitionMongoDao.delete(assetDefinition);
        }
    }

    @Override
    public String buildAssetId(String assetType, String code) {
        return this.buildGeneratorCodeUtil.createAssetId(code, assetType);
    }

    @Override
    public void updateAssetBasicInfo(UpdateAssetBasicInfoReqDto updateAssetBasicInfoReqDto) {
        String assetObjectId = updateAssetBasicInfoReqDto.getAssetObjectId();
        Asset asset = this.assetMongoDao.selectByObjectId(assetObjectId);
        Assert.notNull((Object)asset, (String)"assetObjectId\u4e0d\u80fd\u5b58\u5728\u5bf9\u5e94\u7684\u6570\u636e");
        AssetDefinition assetDefinition = this.assetDefinitionMongoDao.selectByAssetId(asset.getAssetId());
        Assert.notNull((Object)assetDefinition, (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684assetDefinition");
        assetDefinition.setAssetName(updateAssetBasicInfoReqDto.getAssetName());
        assetDefinition.getLang().putAll(updateAssetBasicInfoReqDto.getLang());
        UserHelper.fillEditInfo((Object)assetDefinition);
        asset.setAssetName(updateAssetBasicInfoReqDto.getAssetName());
        asset.getLang().putAll(updateAssetBasicInfoReqDto.getLang());
        UserHelper.fillEditInfo((Object)asset);
        this.assetMongoDao.save(asset);
        this.assetDefinitionMongoDao.save(assetDefinition);
    }
}

