package com.digiwin.athena.mongodb.domain.application;

import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;
import java.util.Map;

/**
 * 资产定义
 */
@Data
@Document(collection = "assetRelation")
public class AssetRelation {
    @Id
    private String objectId;
    // 资产唯一标识
    private String assetId;
    // 业务标识，由各个业务生成，业务中台同步dtd业务中，这个字段是应用code
    private String bizCode;
    // 业务类型
    private String bizType;
    // 引用或归属：ref/own
    private String type;

    private String application;

    private String adpVersion;

    private String userBranch;

    private String createBy;
    private String editBy;
    private Date createDate;
    private Date editDate;

    public enum BelongTypeEnum {

        REF_TYPE("ref", "引用"),
        OWN_TYPE("own", "自用");

        private String type;
        private String description;

        BelongTypeEnum(String type, String description){
            this.type = type;
            this.description = description;
        }

        public String getType() {
            return type;
        }

        // 根据字符串值获取枚举实例
        public static BelongTypeEnum fromString(String value) {
            for (BelongTypeEnum enumValue : BelongTypeEnum.values()) {
                if (enumValue.getType().equals(value)) {
                    return enumValue;
                }
            }
            return null;
        }
    }

    // 自定义setter方法，用于校验type值
    public void setType(String type) {
        BelongTypeEnum enumValue = BelongTypeEnum.fromString(type);
        if (enumValue == null) {
            throw new IllegalArgumentException("当前type数据未找到对应枚举值");
        }
        this.type = enumValue.getType();
    }
}
