package com.digiwin.athena.dao.mongodao.assetType;

import com.digiwin.athena.mongodb.domain.assetType.AssetType;
import com.digiwin.athena.mongodb.repository.MongoRuntimeRepositoryDecorator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Slf4j
@Repository
public class RAssetTypeMongoDao {

    @Autowired
    private MongoRuntimeRepositoryDecorator mongoRuntimeRepositoryDecorator;

    public void deleteById(String objId) {
        Criteria criteria = Criteria.where("_id").is(objId);
        mongoRuntimeRepositoryDecorator.delete(criteria);
    }

    public void insert(AssetType assetType) {
        mongoRuntimeRepositoryDecorator.insert(assetType);
    }

    public AssetType selectById(String objId) {
        Criteria criteria = Criteria.where("_id").is(objId);
        return mongoRuntimeRepositoryDecorator.findOne(new Query(criteria), AssetType.class);
    }

    public void save(AssetType rAssetType) {
        mongoRuntimeRepositoryDecorator.save(rAssetType);
    }

    public List<AssetType> selectByStatus(String status) {
        Criteria criteria = Criteria.where("status").is(status);
        return mongoRuntimeRepositoryDecorator.find(new Query(criteria), AssetType.class);
    }
}
