package com.digiwin.athena.dto.asset;

import com.digiwin.athena.config.BranchConfig;
import com.digiwin.athena.mongodb.domain.application.AssetRelation;
import com.digiwin.athena.utils.user.UserHelper;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

@Data
public class AssetRelationInfoDto {

    private String assetId;
    private String application;

    /**
     * 使用方的多版本，没有多版本就是"0"
     */
    private String adpVersion="0";

    private String userBranch= BranchConfig.DEV_BRANCH_NAME;

    public Boolean judgeRequiredFields() {
        return StringUtils.isNotEmpty(application)
                && StringUtils.isNotEmpty(adpVersion)
                && StringUtils.isNotEmpty(userBranch);
    }

    public AssetRelation convertAssetRelation() {
        AssetRelation assetRelation = new AssetRelation();
        assetRelation.setAssetId(this.assetId);
        assetRelation.setApplication(this.application);
        assetRelation.setAdpVersion(this.adpVersion);
        assetRelation.setUserBranch(this.userBranch);

        UserHelper.fillCreateInfo(assetRelation);
        UserHelper.fillEditInfo(assetRelation);
        return assetRelation;
    }

    public static AssetRelationInfoDto create(String assetId,String application,String userAdpVersion,String userBranch){
        AssetRelationInfoDto assetRelationInfoDto = new AssetRelationInfoDto();
        assetRelationInfoDto.setAssetId(assetId);
        assetRelationInfoDto.setApplication(application);

        if (StringUtils.isNotEmpty(userAdpVersion)) {
            assetRelationInfoDto.setAdpVersion(userAdpVersion);
        }
        if (StringUtils.isNotEmpty(userBranch)) {
            assetRelationInfoDto.setUserBranch(userBranch);
        }

        return assetRelationInfoDto;
    }
}
