package com.digiwin.athena.dto.assetType;

import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.mongodb.domain.assetType.AssetType;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.util.Map;

@Data
public class AssetTypeListResDto {

    private String objId;

    private String type;

    private String name;

    private String version;
    private String category;

    private String owner;
    private String status;
    private String icon;
    private Map<String, MultiLanguageDTO> lang;
    public static AssetTypeListResDto create(AssetType r) {
        AssetTypeListResDto assetTypeListResDto = new AssetTypeListResDto();
        BeanUtils.copyProperties(r,assetTypeListResDto);
        return assetTypeListResDto;
    }
}
