package com.digiwin.athena.mongodb.domain.application;

import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 资产定义
 */
@Data
@Document(collection = "asset")
public class Asset {



    @Id
    private String objectId;
    // 资产唯一标识
    private String assetId;
    // 资产类型
    private String type;
    // 业务标识，由各个设计器创建资产时填写, 非唯一
    private String code;

    // 具体资产内容，可根据配置进行检索，如："task":[{"code" : "start_PM_f468894210000dc4"}]
    private Map<String, List<Map<String,Object>>> content;
    // 所属应用，非必填
    private String application;

    /**
     * 版本号,没有多版本，默认就是0
     */
    private String adpVersion="0";

    /**
     * 备注序列号
     */
    private Integer adpRemarkNumber;

    /**
     *  资产来源|SD-独立资产，CB-组合资产
     */
    private String source;

    private String sourceBranch;

    /**
     * 业务数据
     */
    private String businessData;


    /**
     * 状态|draft-草稿，effect-生效
     */
    private String adpStatus;

    private String createBy;
    private String editBy;
    private Date createDate;
    private Date editDate;

    private String adpRemark;


    private String assetName;
}
