package com.digiwin.athena.mongodb.domain.application;

import com.digiwin.athena.domain.pagedesign.TenantInfo;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
@Document(collection = "assetDefinition")
public class AssetDefinition {

    //0-未上架，1-已上架
    public static final Integer AVAILABLE_STATUS = 1;
    public static final Integer REMOVED_STATUS = 0;

    //开放范围|all-全部，tenant-租户，curTenant-当前租户
    public static final String ALL_RANGE = "all";
    public static final String TENANT_RANGE = "tenant";
    public static final String CUR_TENANT_RANGE = "curTenant";


    @Id
    private String objectId;
    /**
     * 资产id
     */
    private String assetId;
    /**
     * 业务code|比如任务code
     */
    private String code;
    /**
     * 资产类型|DTD
     */
    private String type;
    /**
     * 资产来源|SD-独立资产，CB-组合资产,BC-业务中台
     */
    private String source;
    /**
     * 归属应用
     */
    private String application;
    /**
     * 0-未上架，1-已上架
     */
    private Integer status = 0;
    /**
     * 资产名称
     */
    private String assetName;
    /**
     * 资产描述
     */
    private String assetDesc;
    /**
     * 元信息
     */
    private Map<String, Object> metadata = new HashMap<>();
    /**
     * 标签
     */
    private List<String> tags = new ArrayList<>();
    /**
     * 操作人邮箱
     */
    private String createBy;
    /**
     * 修改人邮箱
     */
    private String editBy;

    private Date createDate;

    private Date editDate;
    /**
     * 租户id
     */
    private String adpTenantId;
    /**
     * 能否引用
     */
    private Boolean canReference = false;
    /**
     * 能否复制
     */
    private Boolean canCopy = false;
    /**
     * 可复制列表,记录的每个版本的objectId
     */
    private List<String> copyableItems = new ArrayList<>();
    /**
     * 发布方，目前记录租户id
     */
    private String publisher;
    private String publisherName;
    /**
     * 开放范围|all-全部，tenant-租户，curTenant-当前租户
     */
    private String openRange = CUR_TENANT_RANGE;
    /**
     * 租户id|openRange=tenant时
     */
    private List<TenantInfo> tenantInfos = new ArrayList<>();
    /**
     * 已复制次数
     */
    private Integer copiedCount = 0;
    /**
     * 已引用次数
     */
    private Integer referencedCount = 0;

    /**
     * 冗余的业务数据，当生效版本被删除的后，会保存这个字段
     */
    private String businessData;

    private Map<String, MultiLanguageDTO> lang;

    public enum AssetTypeEnum{
        DTD("DTD");

        AssetTypeEnum(String code) {
            this.code = code;
        }

        private String code;

        public String getCode() {
            return code;
        }
    }
}
