package com.digiwin.athena.mongodb.domain.assetType;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.mongodb.domain.ApiInfo;
import com.digiwin.athena.mongodb.domain.DataCollectConfig;
import com.digiwin.athena.mongodb.domain.DependencyRule;
import com.digiwin.athena.mongodb.domain.ManageContext;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 资产类型
 */
@Data
@Document(collection = "assetType")
public class AssetType {

    //草稿draft、已上架online、已下架offline
    public static final String STATUS_DRAFT = "draft";
    public static final String STATUS_ONLINE = "online";
    public static final String STATUS_OFFLINE = "offline";

    @Id
    private String objId;

    private String code;

    private String type;

    private String name;

    private String version="1.0";

    /**
     * 关联该资产类型的设计器id
     */
    private List<String> designerIds;

    /**
     * 大类
     */
    private String category;

    /**
     * 资产归属
     */
    private String owner;

    /**
     * status|草稿draft、已上架online、已下架offline
     */
    private String status;

    private String description;

    private String docUrl;

    private String icon;

    /**
     * 资产操作api
     */
    private List<ApiInfo> apiList;

    private List<ApiInfo> openApiList;

    private JSONObject metadata;

    private Date publishTime;

    private List<DependencyRule> dependencyRule;
    private List<ManageContext> manageContextRule;
    private DataCollectConfig dataCollectConfig;
    private Map<String, MultiLanguageDTO> lang;

    private String createBy;
    private String editBy;
    private Date createDate;
    private Date editDate;

}
