package com.digiwin.athena.service.assetType.impl;

import com.digiwin.athena.dao.mongodao.assetType.DAssetTypeMongoDao;
import com.digiwin.athena.dao.mongodao.assetType.RAssetTypeMongoDao;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assetType.AssetTypeListConditionReqDto;
import com.digiwin.athena.dto.assetType.AssetTypeListResDto;
import com.digiwin.athena.dto.assetType.AssetTypeReqDto;
import com.digiwin.athena.dto.assetType.AssetTypeResDto;
import com.digiwin.athena.mongodb.domain.assetType.AssetType;
import com.digiwin.athena.service.assetType.DAssetTypeService;
import com.digiwin.athena.service.codeStandard.BuildGeneratorCodeUtil;
import com.digiwin.athena.utils.user.UserHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service
@Slf4j
public class DAssetTypeServiceImpl implements DAssetTypeService {

    @Autowired
    private DAssetTypeMongoDao dAssetTypeMongoDao;

    @Autowired
    private RAssetTypeMongoDao rAssetTypeMongoDao;
    @Autowired
    private BuildGeneratorCodeUtil buildGeneratorCodeUtil;

    @Override
    public Pagination<AssetTypeListResDto> getAssetTypeList(PageReqCondition<AssetTypeListConditionReqDto> pageReqCondition) {

        Long count = dAssetTypeMongoDao.countAssetTypeList(pageReqCondition);
        List<AssetType> assetTypeList = dAssetTypeMongoDao.getAssetTypeList(pageReqCondition);
        List<AssetTypeListResDto> res = assetTypeList.stream().map(r -> AssetTypeListResDto.create(r)).collect(Collectors.toList());
        return Pagination.buildPagination(pageReqCondition,res,count);
    }

    @Override
    public AssetTypeResDto registerAssetType(AssetTypeReqDto assetTypeReqDto) {

        if (StringUtils.isNotEmpty(assetTypeReqDto.getObjId())){
            AssetType oldAssetType = dAssetTypeMongoDao.selectById(assetTypeReqDto.getObjId());
            Assert.notNull(oldAssetType,"未查询到对应的资产类型");

            if (!assetTypeReqDto.getName().equals(oldAssetType.getName())){
                Long count = dAssetTypeMongoDao.checkExistByNameExcludeType(assetTypeReqDto.getName(),oldAssetType.getType());
                Assert.isTrue(count.equals(0L), "名称已存在");
            }

            if (!assetTypeReqDto.getType().equals(oldAssetType.getType())){
                Long count = dAssetTypeMongoDao.checkExistByTypeExcludeType(assetTypeReqDto.getType(),oldAssetType.getType());
                Assert.isTrue(count.equals(0L), "类型已存在");
            }

            BeanUtils.copyProperties(assetTypeReqDto,oldAssetType);
            UserHelper.fillEditInfo(oldAssetType);
            dAssetTypeMongoDao.save(oldAssetType);

            return AssetTypeResDto.create(oldAssetType);
        }else{
            Long count = dAssetTypeMongoDao.checkExistByNameExcludeType(assetTypeReqDto.getName(),assetTypeReqDto.getType());
            Assert.isTrue(count.equals(0L), "名称已存在");

            AssetType assetType = new AssetType();
            BeanUtils.copyProperties(assetTypeReqDto,assetType);

            UserHelper.fillCreateInfo(assetType);
            UserHelper.fillEditInfo(assetType);
            dAssetTypeMongoDao.insert(assetType);
            return AssetTypeResDto.create(assetType);
        }
    }

    @Override
    public AssetTypeResDto getAssetTypeDetail(String objId) {
        AssetType assetType = dAssetTypeMongoDao.selectById(objId);
        Assert.notNull(assetType,"未查询到对应的资产类型信息");

        return AssetTypeResDto.create(assetType);
    }

    @Override
    public void publish(String objId) {
        AssetType assetType = dAssetTypeMongoDao.selectById(objId);
        Assert.notNull(assetType,"未查询到对应的资产类型信息");

        rAssetTypeMongoDao.deleteById(objId);
        assetType.setStatus(AssetType.STATUS_ONLINE);
        assetType.setPublishTime(new Date());
        UserHelper.fillEditInfo(assetType);

        rAssetTypeMongoDao.insert(assetType);
        dAssetTypeMongoDao.save(assetType);
    }

    @Override
    public void takeDown(String objId) {
        AssetType assetType = dAssetTypeMongoDao.selectById(objId);
        Assert.notNull(assetType,"未查询到对应的资产类型信息");
        Assert.notNull(assetType.getPublishTime(),"未发布无法下架");

        AssetType rAssetType =rAssetTypeMongoDao.selectById(objId);
        if (rAssetType!=null){
            rAssetType.setStatus(AssetType.STATUS_OFFLINE);
            UserHelper.fillEditInfo(assetType);
            rAssetTypeMongoDao.save(rAssetType);
        }

        assetType.setStatus(AssetType.STATUS_OFFLINE);
        UserHelper.fillEditInfo(assetType);
        dAssetTypeMongoDao.save(assetType);
    }

    @Override
    public void launch(String objId) {
        AssetType assetType = dAssetTypeMongoDao.selectById(objId);
        Assert.notNull(assetType,"未查询到对应的资产类型信息");
        Assert.notNull(assetType.getPublishTime(),"未发布无法上架");

        AssetType rAssetType =rAssetTypeMongoDao.selectById(objId);
        if (rAssetType!=null){
            rAssetType.setStatus(AssetType.STATUS_ONLINE);
            UserHelper.fillEditInfo(assetType);
            rAssetTypeMongoDao.save(rAssetType);
        }

        assetType.setStatus(AssetType.STATUS_ONLINE);
        UserHelper.fillEditInfo(assetType);
        dAssetTypeMongoDao.save(assetType);
    }

    public static void main(String[] args) {
        System.out.println("ababab".hashCode());
    }
}
