/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao.mongodao.asset;

import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.mongodb.domain.application.AssetDefinition;
import com.digiwin.athena.mongodb.repository.MongoPrimaryRepositoryDecorator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Repository;

@Repository
public class AssetDefinitionMongoDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetDefinitionMongoDao.class);
    private MongoPrimaryRepositoryDecorator mongoPrimaryRepositoryDecorator;

    @Autowired
    public void setMongoPrimaryRepositoryDecorator(MongoPrimaryRepositoryDecorator mongoPrimaryRepositoryDecorator) {
        this.mongoPrimaryRepositoryDecorator = mongoPrimaryRepositoryDecorator;
    }

    public AssetDefinition selectByApplicationAndCode(String code, String application) {
        Criteria criteria = Criteria.where((String)"code").is((Object)code).and("application").is((Object)application);
        Query query = new Query((CriteriaDefinition)criteria);
        return (AssetDefinition)this.mongoPrimaryRepositoryDecorator.findOne(query, AssetDefinition.class);
    }

    public void insert(AssetDefinition assetDefinition) {
        this.mongoPrimaryRepositoryDecorator.insert((Object)assetDefinition);
    }

    public AssetDefinition selectByAssetId(String assetId) {
        Criteria criteria = Criteria.where((String)"assetId").is((Object)assetId);
        Query query = new Query((CriteriaDefinition)criteria);
        return (AssetDefinition)this.mongoPrimaryRepositoryDecorator.findOne(query, AssetDefinition.class);
    }

    public void updateStatus(Integer status, String editBy, String assetId) {
        Update update = new Update();
        update.set("status", (Object)status);
        update.set("editDate", (Object)new Date());
        update.set("editBy", (Object)editBy);
        Criteria criteria = Criteria.where((String)"assetId").is((Object)assetId);
        this.mongoPrimaryRepositoryDecorator.updateMulti(new Query((CriteriaDefinition)criteria), update, AssetDefinition.class);
    }

    public void save(AssetDefinition assetDefinition) {
        this.mongoPrimaryRepositoryDecorator.save((Object)assetDefinition);
    }

    public List<AssetDefinition> selectByAssetIds(Collection<String> assetIds) {
        Criteria criteria = Criteria.where((String)"assetId").in(assetIds);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoPrimaryRepositoryDecorator.find(query, AssetDefinition.class);
    }

    public List<AssetDefinition> selectPagination(PageReqCondition<String> pageReqCondition, String tenantId, String type) {
        Criteria criteria = this.buildPageCondition(pageReqCondition, tenantId, type);
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(pageReqCondition.getPageSize().intValue());
        query.skip((long)((pageReqCondition.getPageNum() - 1) * pageReqCondition.getPageSize()));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"_id"}));
        return this.mongoPrimaryRepositoryDecorator.find(query, AssetDefinition.class);
    }

    public Long countPagination(PageReqCondition<String> pageReqCondition, String tenantId, String type) {
        Criteria criteria = this.buildPageCondition(pageReqCondition, tenantId, type);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoPrimaryRepositoryDecorator.count(query, AssetDefinition.class);
    }

    public Long countApplicationPagination(PageReqCondition<String> pageReqCondition, String appCode, String type) {
        Criteria criteria = this.buildAdvancedCondition(pageReqCondition);
        if (criteria == null) {
            criteria = Criteria.where((String)"application").is((Object)appCode);
            if (type != null) {
                criteria = criteria.and("type").is((Object)type);
            }
        } else {
            ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
            criteriaList.add(criteria);
            criteriaList.add(Criteria.where((String)"application").is((Object)appCode));
            if (type != null) {
                criteriaList.add(Criteria.where((String)"type").is((Object)type));
            }
            criteria = new Criteria().andOperator(criteriaList);
        }
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoPrimaryRepositoryDecorator.count(query, AssetDefinition.class);
    }

    public List<AssetDefinition> selectApplicationPagination(PageReqCondition<String> pageReqCondition, String appCode, String type) {
        Criteria criteria = this.buildAdvancedCondition(pageReqCondition);
        if (criteria == null) {
            criteria = Criteria.where((String)"application").is((Object)appCode);
            if (type != null) {
                criteria = criteria.and("type").is((Object)type);
            }
        } else {
            Criteria criteria1 = Criteria.where((String)"application").is((Object)appCode);
            if (!StringUtils.isEmpty((CharSequence)type)) {
                criteria1.and("type").is((Object)type);
            }
            criteria = new Criteria().andOperator(new Criteria[]{criteria1, criteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(pageReqCondition.getPageSize().intValue());
        query.skip((long)((pageReqCondition.getPageNum() - 1) * pageReqCondition.getPageSize()));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"_id"}));
        return this.mongoPrimaryRepositoryDecorator.find(query, AssetDefinition.class);
    }

    private Criteria buildPageCondition(PageReqCondition<String> pageReqCondition, String tenantId, String type) {
        Criteria criteria = this.buildAdvancedCondition(pageReqCondition);
        Criteria rangeCriteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)"openRange").is((Object)"all");
        Criteria criteria2 = Criteria.where((String)"openRange").is((Object)"curTenant").and("adpTenantId").is((Object)tenantId);
        Criteria criteria3 = Criteria.where((String)"openRange").is((Object)"tenant").and("tenantInfos.tenantId").in(new Object[]{tenantId});
        rangeCriteria.orOperator(new Criteria[]{criteria3, criteria1, criteria2});
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        criteriaList.add(rangeCriteria);
        criteriaList.add(Criteria.where((String)"status").is((Object)1));
        if (type != null) {
            criteriaList.add(Criteria.where((String)"type").is((Object)type));
        }
        if (criteria == null) {
            criteria = new Criteria();
            criteria.andOperator(criteriaList);
        } else {
            criteriaList.add(criteria);
            criteria = new Criteria().andOperator(criteriaList);
        }
        return criteria;
    }

    private Criteria buildAdvancedCondition(PageReqCondition<String> pageReqCondition) {
        Criteria adVancedCriteria;
        Criteria criteria = null;
        if (pageReqCondition.getAdvancedQueryParams() != null && (adVancedCriteria = pageReqCondition.getAdvancedQueryParams().buildCriteria()) != null) {
            criteria = adVancedCriteria;
        }
        if (criteria == null && StringUtils.isNotEmpty((CharSequence)((CharSequence)pageReqCondition.getCondition()))) {
            Pattern pattern = Pattern.compile(".*" + Pattern.quote((String)pageReqCondition.getCondition()) + ".*", 2);
            criteria = new Criteria();
            criteria.orOperator(new Criteria[]{Criteria.where((String)"assetId").regex(pattern), Criteria.where((String)"assetName").regex(pattern), Criteria.where((String)"assetDesc").regex(pattern)});
        }
        return criteria;
    }

    public List<String> selectAssetIdAvailableStatusByApplication(String appCode, String type) {
        Criteria criteria = Criteria.where((String)"application").is((Object)appCode).and("status").is((Object)AssetDefinition.AVAILABLE_STATUS).and("type").is((Object)type);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include("assetId");
        return this.mongoPrimaryRepositoryDecorator.find(query, AssetDefinition.class).stream().map(AssetDefinition::getAssetId).collect(Collectors.toList());
    }

    public Long countSameTenantDtdAsset(PageReqCondition<String> pageReqCondition, String tenantId, String type) {
        Criteria criteria = this.buildAdvancedCondition(pageReqCondition);
        criteria = criteria == null ? Criteria.where((String)"adpTenantId").is((Object)tenantId).and("type").is((Object)type) : new Criteria().andOperator(new Criteria[]{Criteria.where((String)"adpTenantId").is((Object)tenantId), Criteria.where((String)"type").is((Object)type), criteria});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(pageReqCondition.getPageSize().intValue());
        query.skip((long)((pageReqCondition.getPageNum() - 1) * pageReqCondition.getPageSize()));
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        return this.mongoPrimaryRepositoryDecorator.count(query, AssetDefinition.class);
    }

    public List<AssetDefinition> selectSameTenantDtdAsset(PageReqCondition<String> pageReqCondition, String tenantId, String type) {
        Criteria criteria = this.buildAdvancedCondition(pageReqCondition);
        criteria = criteria == null ? Criteria.where((String)"adpTenantId").is((Object)tenantId).and("type").is((Object)type) : new Criteria().andOperator(new Criteria[]{Criteria.where((String)"adpTenantId").is((Object)tenantId), Criteria.where((String)"type").is((Object)type), criteria});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(pageReqCondition.getPageSize().intValue());
        query.skip((long)((pageReqCondition.getPageNum() - 1) * pageReqCondition.getPageSize()));
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        return this.mongoPrimaryRepositoryDecorator.find(query, AssetDefinition.class);
    }

    public Long countPlatformDtdAsset(PageReqCondition<String> pageReqCondition, String tenantId, String type) {
        Criteria criteria = this.buildAdvancedCondition(pageReqCondition);
        if (criteria == null) {
            criteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"adpTenantId").ne((Object)tenantId).and("type").is((Object)type).and("openRange").is((Object)"all"), Criteria.where((String)"adpTenantId").ne((Object)tenantId).and("type").is((Object)type).and("openRange").is((Object)"tenant").and("tenantInfos.tenantId").in(new Object[]{tenantId})});
        } else {
            Criteria criteria2 = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"adpTenantId").ne((Object)tenantId).and("type").is((Object)type).and("openRange").is((Object)"all"), Criteria.where((String)"adpTenantId").ne((Object)tenantId).and("type").is((Object)type).and("openRange").is((Object)"tenant").and("tenantInfos.tenantId").in(new Object[]{tenantId})});
            criteria = new Criteria().andOperator(new Criteria[]{criteria2, criteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(pageReqCondition.getPageSize().intValue());
        query.skip((long)((pageReqCondition.getPageNum() - 1) * pageReqCondition.getPageSize()));
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        return this.mongoPrimaryRepositoryDecorator.count(query, AssetDefinition.class);
    }

    public List<AssetDefinition> selectPlatformDtdAsset(PageReqCondition<String> pageReqCondition, String tenantId, String type) {
        Criteria criteria = this.buildAdvancedCondition(pageReqCondition);
        if (criteria == null) {
            criteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"adpTenantId").ne((Object)tenantId).and("type").is((Object)type).and("openRange").is((Object)"all"), Criteria.where((String)"adpTenantId").ne((Object)tenantId).and("type").is((Object)type).and("openRange").is((Object)"tenant").and("tenantInfos.tenantId").in(new Object[]{tenantId})});
        } else {
            Criteria criteria2 = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"adpTenantId").ne((Object)tenantId).and("type").is((Object)type).and("openRange").is((Object)"all"), Criteria.where((String)"adpTenantId").ne((Object)tenantId).and("type").is((Object)type).and("openRange").is((Object)"tenant").and("tenantInfos.tenantId").in(new Object[]{tenantId})});
            criteria = new Criteria().andOperator(new Criteria[]{criteria2, criteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(pageReqCondition.getPageSize().intValue());
        query.skip((long)((pageReqCondition.getPageNum() - 1) * pageReqCondition.getPageSize()));
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        return this.mongoPrimaryRepositoryDecorator.find(query, AssetDefinition.class);
    }

    public List<AssetDefinition> selectBasicByApplicationAndCodes(String application, List<String> codes) {
        Criteria criteria = Criteria.where((String)"code").in(codes).and("application").is((Object)application);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include(new String[]{"assetId", "code", "type", "assetName", "application"});
        return this.mongoPrimaryRepositoryDecorator.find(query, AssetDefinition.class);
    }

    public List<AssetDefinition> selectByAssetIdsAndStatus(List<String> assetIds, Integer status) {
        Criteria criteria = Criteria.where((String)"assetId").in(assetIds).and("status").is((Object)status);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoPrimaryRepositoryDecorator.find(query, AssetDefinition.class);
    }
}

