/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao.mongodao.asset;

import com.digiwin.athena.enums.VersionStatusEnum;
import com.digiwin.athena.mongodb.domain.application.Asset;
import com.digiwin.athena.mongodb.domain.application.AssetDefinition;
import com.digiwin.athena.mongodb.repository.MongoPrimaryRepositoryDecorator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Repository;

@Repository
public class AssetMongoDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetMongoDao.class);
    @Autowired
    private MongoPrimaryRepositoryDecorator mongoPrimaryRepositoryDecorator;

    public void save(Asset asset) {
        this.mongoPrimaryRepositoryDecorator.save((Object)asset);
    }

    public Asset findOne(String assetId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"assetId").is((Object)assetId));
        return (Asset)this.mongoPrimaryRepositoryDecorator.findOne(query, Asset.class);
    }

    public List<Asset> findByApplication(String application) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application));
        return this.mongoPrimaryRepositoryDecorator.find(query, Asset.class);
    }

    public List<Asset> findByAssetIds(List<String> assetIds) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"assetId").in(assetIds));
        return this.mongoPrimaryRepositoryDecorator.find(query, Asset.class);
    }

    public void delete(String assetId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"assetId").is((Object)assetId));
        this.mongoPrimaryRepositoryDecorator.delete(query, Asset.class);
    }

    public void insert(Asset asset) {
        this.mongoPrimaryRepositoryDecorator.insert((Object)asset);
    }

    public void delete(Asset asset) {
        this.mongoPrimaryRepositoryDecorator.delete((Object)asset);
    }

    public List<Asset> selectByCodeAndApplication(String code, String application) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("code").is((Object)code);
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public List<Asset> selectByAssetId(String assetId) {
        Criteria criteria = Criteria.where((String)"assetId").is((Object)assetId);
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public Asset selectByAssetIdAndSourceBranchAndAdpVersion(String assetId, String sourceBranch, String adpVersion) {
        Criteria criteria = Criteria.where((String)"assetId").is((Object)assetId).and("sourceBranch").is((Object)sourceBranch).and("adpVersion").is((Object)adpVersion);
        return (Asset)this.mongoPrimaryRepositoryDecorator.findOne(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public void updateDraftAdpStatusByAssetId(String editBy, String assetId) {
        Update update = new Update();
        update.set("adpStatus", (Object)"draft");
        update.set("editDate", (Object)new Date());
        update.set("editBy", (Object)editBy);
        Criteria criteria = Criteria.where((String)"assetId").is((Object)assetId).and("adpStatus").is((Object)"effect");
        this.mongoPrimaryRepositoryDecorator.updateMulti(new Query((CriteriaDefinition)criteria), update, Asset.class);
    }

    public Asset selectEffectByAssetId(String assetId) {
        Criteria criteria = Criteria.where((String)"assetId").is((Object)assetId).and("adpStatus").is((Object)"effect");
        return (Asset)this.mongoPrimaryRepositoryDecorator.findOne(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public List<Asset> selectEffectByAssetIds(Collection<String> assetIds) {
        Criteria criteria = Criteria.where((String)"assetId").in(assetIds).and("adpStatus").is((Object)"effect");
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public List<Asset> selectBasicInfoByObjectId(List<String> objIds) {
        Criteria criteria = Criteria.where((String)"_id").in(objIds);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().exclude(new String[]{"businessData", "content"});
        return this.mongoPrimaryRepositoryDecorator.find(query, Asset.class);
    }

    public Asset selectByObjectId(String objId) {
        Criteria criteria = Criteria.where((String)"_id").is((Object)objId);
        Query query = new Query((CriteriaDefinition)criteria);
        return (Asset)this.mongoPrimaryRepositoryDecorator.findOne(query, Asset.class);
    }

    public List<Asset> selectByCodeAndApplicationAndSourceBranchAndAdpVersion(Asset asset) {
        Criteria criteria = Criteria.where((String)"code").is((Object)asset.getCode()).and("application").is((Object)asset.getApplication()).and("sourceBranch").is((Object)asset.getSourceBranch());
        if (StringUtils.isNotEmpty((CharSequence)asset.getAdpVersion())) {
            criteria.and("adpVersion").is((Object)asset.getAdpVersion());
        }
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public void deleteByCodeAndApplicationAndSourceBranchAndAdpVersion(Asset asset) {
        Criteria criteria = Criteria.where((String)"code").is((Object)asset.getCode()).and("application").is((Object)asset.getApplication()).and("sourceBranch").is((Object)asset.getSourceBranch());
        if (StringUtils.isNotEmpty((CharSequence)asset.getAdpVersion())) {
            criteria.and("adpVersion").is((Object)asset.getAdpVersion());
        }
        this.mongoPrimaryRepositoryDecorator.delete(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public Asset selectLatestVersionByAssetIdAndSourceBranchAndApplication(String assetId, String branch, String application) {
        Criteria criteria = Criteria.where((String)"assetId").is((Object)assetId).and("application").is((Object)application).and("sourceBranch").is((Object)branch);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"adpVersion"}));
        query.limit(1);
        return (Asset)this.mongoPrimaryRepositoryDecorator.findOne(query, Asset.class);
    }

    public Asset selectAssetIdByCodeAndApplication(String code, String application) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("code").is((Object)code);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include("assetId");
        query.limit(1);
        return (Asset)this.mongoPrimaryRepositoryDecorator.findOne(query, Asset.class);
    }

    public List<Asset> selectByApplicationAndAdpVersionAndBranch(String application, String adpVersion, String branch) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application);
        if (StringUtils.isNotEmpty((CharSequence)adpVersion)) {
            criteria.and("adpVersion").is((Object)adpVersion);
        }
        if (StringUtils.isNotEmpty((CharSequence)branch)) {
            criteria.and("sourceBranch").is((Object)branch);
        }
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public List<String> selectAllId() {
        Query query = new Query();
        query.fields().include("_id");
        return this.mongoPrimaryRepositoryDecorator.find(new Query(), Asset.class).stream().map(Asset::getObjectId).collect(Collectors.toList());
    }

    public Long selectEffectCount(List<String> assetIds) {
        Criteria criteria = Criteria.where((String)"assetId").in(assetIds).and("adpStatus").is((Object)VersionStatusEnum.RUN_STATE.getCode());
        return this.mongoPrimaryRepositoryDecorator.count(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public Set<String> selectExistAssetId(List<String> assetIds) {
        Criteria criteria = Criteria.where((String)"assetId").in(assetIds);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include("assetId");
        return this.mongoPrimaryRepositoryDecorator.find(query, Asset.class).stream().map(Asset::getAssetId).collect(Collectors.toSet());
    }

    public Asset selectLastOneNew(String assetId) {
        Criteria criteria = Criteria.where((String)"assetId").is((Object)assetId).and("sourceBranch").is((Object)"develop");
        return (Asset)this.mongoPrimaryRepositoryDecorator.findOne(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public List<Asset> selectByApplicationAndBranch(String application, String branch) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("sourceBranch").is((Object)branch);
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public void insertAll(List<Asset> assetList) {
        this.mongoPrimaryRepositoryDecorator.insertAll(assetList);
    }

    public void deleteByApplicationAndBranch(String application, String branch) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("sourceBranch").is((Object)branch);
        this.mongoPrimaryRepositoryDecorator.remove(new Query((CriteriaDefinition)criteria), Asset.class);
    }

    public void updateDraftByApplicationAndType(String application, AssetDefinition.AssetTypeEnum assetTypeEnum) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("type").is((Object)assetTypeEnum.getCode());
        Update update = new Update();
        update.set("adpStatus", (Object)"draft");
        this.mongoPrimaryRepositoryDecorator.updateMulti(new Query((CriteriaDefinition)criteria), update, Asset.class);
    }
}

