/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao.mongodao.asset;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.asset.AssetRelationInfoDto;
import com.digiwin.athena.mongodb.domain.application.AssetDefinition;
import com.digiwin.athena.mongodb.domain.application.AssetRelation;
import com.digiwin.athena.mongodb.repository.MongoPrimaryRepositoryDecorator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class AssetRelationMongoDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetRelationMongoDao.class);
    @Autowired
    private MongoPrimaryRepositoryDecorator mongoPrimaryRepositoryDecorator;

    public void save(AssetRelation assetRelation) {
        this.mongoPrimaryRepositoryDecorator.save((Object)assetRelation);
    }

    public List<AssetRelation> find(String assetId, String application) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"assetId").is((Object)assetId).and("application").is((Object)application));
        return this.mongoPrimaryRepositoryDecorator.find(query, AssetRelation.class);
    }

    public List<AssetRelation> findByApplication(String application) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("bizType").is((Object)"DTD"));
        return this.mongoPrimaryRepositoryDecorator.find(query, AssetRelation.class);
    }

    public List<AssetRelation> findByRefApplication(String application) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("type").is((Object)"ref").and("bizType").is((Object)"DTD"));
        return this.mongoPrimaryRepositoryDecorator.find(query, AssetRelation.class);
    }

    @Deprecated
    public void delete(String assetId, String application, String type) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"assetId").is((Object)assetId).and("application").is((Object)application).and("type").is((Object)type));
        this.mongoPrimaryRepositoryDecorator.delete(query, AssetRelation.class);
    }

    public AssetRelation selectByAssetIdAndAdpVersionAndUserBranchAndApplication(AssetRelationInfoDto assetRelationInfoDto) {
        Criteria criteria = Criteria.where((String)"assetId").is((Object)assetRelationInfoDto.getAssetId()).and("application").is((Object)assetRelationInfoDto.getApplication()).and("userBranch").is((Object)assetRelationInfoDto.getUserBranch()).and("adpVersion").is((Object)assetRelationInfoDto.getAdpVersion());
        return (AssetRelation)this.mongoPrimaryRepositoryDecorator.findOne(new Query((CriteriaDefinition)criteria), AssetRelation.class);
    }

    public void insert(AssetRelation assetRelation) {
        this.mongoPrimaryRepositoryDecorator.insert((Object)assetRelation);
    }

    public void delete(AssetRelationInfoDto assetRelationInfoDto) {
        Criteria criteria = Criteria.where((String)"application").is((Object)assetRelationInfoDto.getApplication()).and("userBranch").is((Object)assetRelationInfoDto.getUserBranch()).and("adpVersion").is((Object)assetRelationInfoDto.getAdpVersion());
        this.mongoPrimaryRepositoryDecorator.delete(new Query((CriteriaDefinition)criteria), AssetRelation.class);
    }

    public List<AssetRelation> select(AssetRelationInfoDto assetRelationInfoDto, AssetDefinition.AssetTypeEnum assetTypeEnum) {
        Criteria criteria = Criteria.where((String)"application").is((Object)assetRelationInfoDto.getApplication()).and("bizType").is((Object)assetTypeEnum.getCode()).and("type").is((Object)"ref");
        if (StringUtils.isNotEmpty((CharSequence)assetRelationInfoDto.getUserBranch())) {
            criteria.and("userBranch").is((Object)assetRelationInfoDto.getUserBranch());
        }
        if (StringUtils.isNotEmpty((CharSequence)assetRelationInfoDto.getAdpVersion())) {
            criteria.and("adpVersion").is((Object)assetRelationInfoDto.getAdpVersion());
        }
        if (StringUtils.isNotEmpty((CharSequence)assetRelationInfoDto.getAssetId())) {
            criteria.and("assetId").is((Object)assetRelationInfoDto.getAssetId());
        }
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), AssetRelation.class);
    }

    public Long selectRefCountByAssetIdAndApplication(String assetId, String application) {
        Criteria criteria = Criteria.where((String)"assetId").is((Object)assetId).and("application").is((Object)application);
        return this.mongoPrimaryRepositoryDecorator.count(new Query((CriteriaDefinition)criteria), AssetRelation.class);
    }

    public void deleteByAssetIdsAndVersionAndBranchAndApp(List<String> assetIds, String adpVersion, String branch, String application) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("userBranch").is((Object)branch).and("adpVersion").is((Object)adpVersion).and("assetId").in(assetIds);
        this.mongoPrimaryRepositoryDecorator.delete(new Query((CriteriaDefinition)criteria), AssetRelation.class);
    }

    public Collection<String> selectRefAppAppByAssetId(String assetId) {
        Criteria criteria = Criteria.where((String)"assetId").is((Object)assetId).and("type").is((Object)"ref");
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include("application");
        return this.mongoPrimaryRepositoryDecorator.find(query, AssetRelation.class).stream().map(AssetRelation::getApplication).collect(Collectors.toSet());
    }

    public List<AssetRelation> selectByAssetId(String assetId) {
        Criteria criteria = Criteria.where((String)"assetId").is((Object)assetId);
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), AssetRelation.class);
    }

    public List<String> selectAssetIdByAppCode(String appCode, String type) {
        Criteria criteria = Criteria.where((String)"application").is((Object)appCode).and("bizType").is((Object)type);
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), AssetRelation.class).stream().map(AssetRelation::getAssetId).collect(Collectors.toList());
    }

    public Long selectCountPagination(PageReqCondition<String> pageReqCondition, String appCode, String type) {
        Criteria criteria = AssetRelationMongoDao.buildAdvancedCondition(pageReqCondition);
        if (criteria == null) {
            criteria = Criteria.where((String)"application").is((Object)appCode).and("type").is((Object)"ref");
            if (!StringUtils.isEmpty((CharSequence)type)) {
                criteria = criteria.and("bizType").is((Object)type);
            }
        } else {
            Criteria criteria1 = Criteria.where((String)"application").is((Object)appCode).and("type").is((Object)"ref");
            if (!StringUtils.isEmpty((CharSequence)type)) {
                criteria1 = criteria1.and("bizType").is((Object)type);
            }
            criteria = new Criteria().andOperator(new Criteria[]{criteria1, criteria});
        }
        MatchOperation match = Aggregation.match((Criteria)criteria);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{match, Aggregation.group((String[])new String[]{"assetId"}), Aggregation.count().as("total")});
        AggregationResults res = this.mongoPrimaryRepositoryDecorator.aggregate(aggregation, AssetRelation.class, JSONObject.class);
        if (CollectionUtils.isEmpty((Collection)res.getMappedResults())) {
            return 0L;
        }
        return ((JSONObject)res.getMappedResults().get(0)).getInteger("total").longValue();
    }

    public List<AssetRelation> selectPagination(PageReqCondition<String> pageReqCondition, String appCode, String type) {
        Criteria criteria = AssetRelationMongoDao.buildAdvancedCondition(pageReqCondition);
        if (criteria == null) {
            criteria = Criteria.where((String)"application").is((Object)appCode).and("type").is((Object)"ref");
            if (!StringUtils.isEmpty((CharSequence)type)) {
                criteria = criteria.and("bizType").is((Object)type);
            }
        } else {
            Criteria criteria1 = Criteria.where((String)"application").is((Object)appCode).and("type").is((Object)"ref");
            if (!StringUtils.isEmpty((CharSequence)type)) {
                criteria1 = criteria1.and("bizType").is((Object)type);
            }
            criteria = new Criteria().andOperator(new Criteria[]{criteria1, criteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(pageReqCondition.getPageSize().intValue());
        query.skip((long)((pageReqCondition.getPageNum() - 1) * pageReqCondition.getPageSize()));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"_id"}));
        MatchOperation match = Aggregation.match((Criteria)criteria);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{match, Aggregation.group((String[])new String[]{"assetId"}).first(Aggregation.ROOT).as("doc"), Aggregation.sort((Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"_id"})), Aggregation.skip((long)((pageReqCondition.getPageNum() - 1) * pageReqCondition.getPageSize())), Aggregation.limit((long)pageReqCondition.getPageSize().intValue())});
        AggregationResults res = this.mongoPrimaryRepositoryDecorator.aggregate(aggregation, "assetRelation", JSONObject.class);
        List<AssetRelation> result = res.getMappedResults().stream().map(j -> {
            Map doc = (Map)j.get((Object)"doc");
            doc.put("objectId", doc.get("_id").toString());
            return (AssetRelation)JSONObject.parseObject((String)JSONObject.toJSONString((Object)doc), AssetRelation.class);
        }).collect(Collectors.toList());
        return result;
    }

    private static Criteria buildAdvancedCondition(PageReqCondition<String> pageReqCondition) {
        Criteria adVancedCriteria;
        Criteria criteria = null;
        if (pageReqCondition.getAdvancedQueryParams() != null && (adVancedCriteria = pageReqCondition.getAdvancedQueryParams().buildCriteria()) != null) {
            criteria = adVancedCriteria;
        }
        if (criteria == null && StringUtils.isNotEmpty((CharSequence)((CharSequence)pageReqCondition.getCondition()))) {
            Pattern pattern = Pattern.compile(".*" + Pattern.quote((String)pageReqCondition.getCondition()) + ".*", 2);
            criteria = new Criteria();
            criteria.orOperator(new Criteria[]{Criteria.where((String)"assetId").regex(pattern)});
        }
        return criteria;
    }

    public AssetRelation selectByObjectId(String objectId) {
        Criteria criteria = Criteria.where((String)"_id").is((Object)objectId);
        return (AssetRelation)this.mongoPrimaryRepositoryDecorator.findOne(new Query((CriteriaDefinition)criteria), AssetRelation.class);
    }

    public void deleteByObjectId(String objectId) {
        Criteria criteria = Criteria.where((String)"_id").is((Object)objectId);
        this.mongoPrimaryRepositoryDecorator.delete(new Query((CriteriaDefinition)criteria), AssetRelation.class);
    }

    public List<AssetRelation> selectByApplicationAndBranch(String application, String userBranch) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("userBranch").is((Object)userBranch);
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), AssetRelation.class);
    }

    public void insertAll(List<AssetRelation> relations) {
        this.mongoPrimaryRepositoryDecorator.insertAll(relations);
    }

    public void deleteByApplicationAndBranch(String application, String userBranch) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("userBranch").is((Object)userBranch);
        this.mongoPrimaryRepositoryDecorator.delete(new Query((CriteriaDefinition)criteria), AssetRelation.class);
    }

    public AssetRelation findOneAssetRelation(String application) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("bizType").is((Object)"DTD"));
        return (AssetRelation)this.mongoPrimaryRepositoryDecorator.findOne(query, AssetRelation.class);
    }

    public List<AssetRelation> selectByApplicationAndBranchAndVersion(String application, String adpVersion, String branch) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("userBranch").is((Object)branch).and("adpVersion").is((Object)adpVersion).and("type").is((Object)"ref");
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), AssetRelation.class);
    }

    public List<AssetRelation> selectByAssetIdAndType(String assetId, String type) {
        Criteria criteria = Criteria.where((String)"assetId").is((Object)assetId).and("type").is((Object)type);
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), AssetRelation.class);
    }
}

