/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.assetType.impl;

import com.digiwin.athena.dao.mongodao.assetType.DAssetTypeMongoDao;
import com.digiwin.athena.dao.mongodao.assetType.RAssetTypeMongoDao;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assetType.AssetTypeListConditionReqDto;
import com.digiwin.athena.dto.assetType.AssetTypeListResDto;
import com.digiwin.athena.dto.assetType.AssetTypeReqDto;
import com.digiwin.athena.dto.assetType.AssetTypeResDto;
import com.digiwin.athena.mongodb.domain.assetType.AssetType;
import com.digiwin.athena.service.assetType.DAssetTypeService;
import com.digiwin.athena.service.codeStandard.BuildGeneratorCodeUtil;
import com.digiwin.athena.utils.user.UserHelper;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class DAssetTypeServiceImpl
implements DAssetTypeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DAssetTypeServiceImpl.class);
    @Autowired
    private DAssetTypeMongoDao dAssetTypeMongoDao;
    @Autowired
    private RAssetTypeMongoDao rAssetTypeMongoDao;
    @Autowired
    private BuildGeneratorCodeUtil buildGeneratorCodeUtil;

    @Override
    public Pagination<AssetTypeListResDto> getAssetTypeList(PageReqCondition<AssetTypeListConditionReqDto> pageReqCondition) {
        Long count = this.dAssetTypeMongoDao.countAssetTypeList(pageReqCondition);
        List<AssetType> assetTypeList = this.dAssetTypeMongoDao.getAssetTypeList(pageReqCondition);
        List res = assetTypeList.stream().map(r -> AssetTypeListResDto.create(r)).collect(Collectors.toList());
        return Pagination.buildPagination(pageReqCondition, res, (Long)count);
    }

    @Override
    public AssetTypeResDto registerAssetType(AssetTypeReqDto assetTypeReqDto) {
        if (StringUtils.isNotEmpty((CharSequence)assetTypeReqDto.getObjId())) {
            Long count;
            AssetType oldAssetType = this.dAssetTypeMongoDao.selectById(assetTypeReqDto.getObjId());
            Assert.notNull((Object)oldAssetType, (String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8d44\u4ea7\u7c7b\u578b");
            if (!assetTypeReqDto.getName().equals(oldAssetType.getName())) {
                count = this.dAssetTypeMongoDao.checkExistByNameExcludeType(assetTypeReqDto.getName(), oldAssetType.getType());
                Assert.isTrue((boolean)count.equals(0L), (String)"\u540d\u79f0\u5df2\u5b58\u5728");
            }
            if (!assetTypeReqDto.getType().equals(oldAssetType.getType())) {
                count = this.dAssetTypeMongoDao.checkExistByTypeExcludeType(assetTypeReqDto.getType(), oldAssetType.getType());
                Assert.isTrue((boolean)count.equals(0L), (String)"\u7c7b\u578b\u5df2\u5b58\u5728");
            }
            BeanUtils.copyProperties((Object)assetTypeReqDto, (Object)oldAssetType);
            UserHelper.fillEditInfo((Object)oldAssetType);
            this.dAssetTypeMongoDao.save(oldAssetType);
            return AssetTypeResDto.create(oldAssetType);
        }
        Long count = this.dAssetTypeMongoDao.checkExistByNameExcludeType(assetTypeReqDto.getName(), assetTypeReqDto.getType());
        Assert.isTrue((boolean)count.equals(0L), (String)"\u540d\u79f0\u5df2\u5b58\u5728");
        AssetType assetType = new AssetType();
        BeanUtils.copyProperties((Object)assetTypeReqDto, (Object)assetType);
        UserHelper.fillCreateInfo((Object)assetType);
        UserHelper.fillEditInfo((Object)assetType);
        this.dAssetTypeMongoDao.insert(assetType);
        return AssetTypeResDto.create(assetType);
    }

    @Override
    public AssetTypeResDto getAssetTypeDetail(String objId) {
        AssetType assetType = this.dAssetTypeMongoDao.selectById(objId);
        Assert.notNull((Object)assetType, (String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8d44\u4ea7\u7c7b\u578b\u4fe1\u606f");
        return AssetTypeResDto.create(assetType);
    }

    @Override
    public void publish(String objId) {
        AssetType assetType = this.dAssetTypeMongoDao.selectById(objId);
        Assert.notNull((Object)assetType, (String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8d44\u4ea7\u7c7b\u578b\u4fe1\u606f");
        this.rAssetTypeMongoDao.deleteById(objId);
        assetType.setStatus("online");
        assetType.setPublishTime(new Date());
        UserHelper.fillEditInfo((Object)assetType);
        this.rAssetTypeMongoDao.insert(assetType);
        this.dAssetTypeMongoDao.save(assetType);
    }

    @Override
    public void takeDown(String objId) {
        AssetType assetType = this.dAssetTypeMongoDao.selectById(objId);
        Assert.notNull((Object)assetType, (String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8d44\u4ea7\u7c7b\u578b\u4fe1\u606f");
        Assert.notNull((Object)assetType.getPublishTime(), (String)"\u672a\u53d1\u5e03\u65e0\u6cd5\u4e0b\u67b6");
        AssetType rAssetType = this.rAssetTypeMongoDao.selectById(objId);
        if (rAssetType != null) {
            rAssetType.setStatus("offline");
            UserHelper.fillEditInfo((Object)assetType);
            this.rAssetTypeMongoDao.save(rAssetType);
        }
        assetType.setStatus("offline");
        UserHelper.fillEditInfo((Object)assetType);
        this.dAssetTypeMongoDao.save(assetType);
    }

    @Override
    public void launch(String objId) {
        AssetType assetType = this.dAssetTypeMongoDao.selectById(objId);
        Assert.notNull((Object)assetType, (String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8d44\u4ea7\u7c7b\u578b\u4fe1\u606f");
        Assert.notNull((Object)assetType.getPublishTime(), (String)"\u672a\u53d1\u5e03\u65e0\u6cd5\u4e0a\u67b6");
        AssetType rAssetType = this.rAssetTypeMongoDao.selectById(objId);
        if (rAssetType != null) {
            rAssetType.setStatus("online");
            UserHelper.fillEditInfo((Object)assetType);
            this.rAssetTypeMongoDao.save(rAssetType);
        }
        assetType.setStatus("online");
        UserHelper.fillEditInfo((Object)assetType);
        this.dAssetTypeMongoDao.save(assetType);
    }

    public static void main(String[] args) {
        System.out.println("ababab".hashCode());
    }
}

