/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao;

import com.digiwin.athena.auth.metadata.domain.ResourceAuthorization;
import com.digiwin.athena.auth.metadata.enums.AuthStatusEnum;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class ResourceAuthorizationMongoDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceAuthorizationMongoDao.class);
    @Autowired
    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;

    public void removeByToAuditCondition(String userId, List<String> appCodes, String tenantId) {
        Criteria toAuditCondition = Criteria.where((String)"accreditObject").is((Object)userId).and("status").is((Object)AuthStatusEnum.TO_AUDIT.name());
        Criteria resourceIdCondition = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"resourceId").in(appCodes), Criteria.where((String)"resourceId").is((Object)tenantId)});
        this.mongoSystemRepositoryDecorator.remove(new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{toAuditCondition, resourceIdCondition})), ResourceAuthorization.class);
    }

    public void removeByAccreditObjectAndRoleAndResourceIdAndStatus(String accreditObject, String roleType, String resourceId, String name) {
        Criteria toAuditSameRoleCondition = Criteria.where((String)"accreditObject").is((Object)accreditObject).and("accreditRole").regex(roleType).and("resourceId").is((Object)resourceId).and("status").is((Object)name);
        this.mongoSystemRepositoryDecorator.remove(new Query((CriteriaDefinition)toAuditSameRoleCondition), ResourceAuthorization.class);
    }

    public void insert(ResourceAuthorization resourceAuthorization) {
        this.mongoSystemRepositoryDecorator.insert((Object)resourceAuthorization);
    }

    public void removeByRoleAndResourceIdAndAccreditObject(String accreditRole, String resourceId, String accreditObject) {
        Criteria criteria = Criteria.where((String)"accreditRole").is((Object)accreditRole).and("resourceId").is((Object)resourceId).and("accreditObject").is((Object)accreditObject);
        this.mongoSystemRepositoryDecorator.remove(new Query((CriteriaDefinition)criteria), ResourceAuthorization.class);
    }
}

